$(document).ready(function() {

    // We initialize the modal
    ModalFlux.initialisation( LancerFlux.modal_id );

    if ( ModalFlux.loaded ) {

        // We initialize the onclick function [ Action par lot ]
        LancerFlux.setClickActionLotBtn();
    }

    $('#form_flux_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_flux_btn_execute').click(function(){
        LancerFlux.lancerFluxDossiers();
    });

    $('#form_flux_unitaire_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_flux_unitaire_btn_execute').click(function(){
        LancerFlux.lancerFluxUnitaire();
    });

});

// We create an instance of the OdeModal object
const ModalFlux = Object.create(OdeModal);

if( typeof(LancerFlux) == 'undefined' ){ var LancerFlux = { modal_id: 'ode_modal_flux', loaded: false }; }

// We initialize the onclick function [ Action par lot ]
LancerFlux.setClickActionLotBtn = function(){
    $('[role="ode-modal-flux-btn"]').off().on('click', function () {
        $('#form_flux_btn_terminer').text('Annuler');
        $('#form_flux_btn_execute').show();
        ModalFlux.initialisation( LancerFlux.modal_id );
        ModalFlux.open();
        LancerFlux.initialisation();
    });

    $('[role="ode-modal-flux-unitaire-btn"]').off().on('click', function () {
        $('#form_flux_unitaire_btn_terminer').text('Annuler');
        $('#form_flux_unitaire_btn_execute').show();
        ModalFlux.initialisation( LancerFlux.modal_id );
        ModalFlux.open();
        LancerFlux.initialisationUnitaire();
    });
}

LancerFlux.initialisation = function(){ 

    ModalFlux.route('loading');

    var loading = function(){
        ModalFlux.loading.setMessage('Récupération des dossiers séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalFlux.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
            ModalFlux.route('erreur',this.result.erreur);
            return; 
        }

        var message = ( this.result.dossiers_selected.nb === 1 ) 
                    ? `Récupération du dossier séléctionné`
                    : `Récupération des ${this.result.dossiers_selected.nb} dossiers séléctionnés`;

        ModalFlux.loading.setMessage(message);
        ModalFlux.loading.setTotal(this.result.dossiers_selected.nb);

        for(var i = 0; i < this.result.dossiers_selected.nb; i++){
            ModalFlux.loading.increaseCurrent();
        }

        setTimeout(() => {
            ModalFlux.route('flux');
            ModalFlux.loading.reset();
            retourFunctionFlux.initChoixFlux(this);
        }, 1000);
    };

    var dossiers = LancerFlux.getSelectedDossiers();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_flux');
    query.setAction("initChoixFlux");
    query.setPostData( dossiers );
    OdeAjax.getByAction( query, loading, callBack );
}

LancerFlux.initialisationUnitaire = function(){ 

    ModalFlux.route('loading');

    var loading = function(){
        ModalFlux.loading.setMessage('Récupération du dossier');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalFlux.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
            ModalFlux.route('erreur',this.result.erreur);
            return; 
        }

        var message = `Récupération du dossier`;

        ModalFlux.loading.setMessage(message);
        ModalFlux.loading.setTotal(1);
        ModalFlux.loading.increaseCurrent();

        setTimeout(() => {
            ModalFlux.route('flux');
            ModalFlux.loading.reset();
            retourFunctionFlux.initChoixUnitaire(this);
        }, 1000);
    };

    var dossier = getDataFunctionFlux.initChoixUnitaire();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_flux');
    query.setAction("initChoixUnitaire");
    query.setPostData( dossier );
    OdeAjax.getByAction( query, loading, callBack );
}



LancerFlux.lancerFluxDossiers = function(){
    var flux_id = $("#select_flux").children("option:selected").attr("id");
    if( flux_id !== undefined ){
        $("#tbody_resultat_flux").empty(); 
        $("#small_select_flux").hide();
        $("#select_flux").css('border', '1px solid green');

        var isGroupeFlux = $('#'+flux_id).attr('data-is-lot') ;
        var dossiers_selected_ids = $("#dossiers_selected_ids").val();
        var obj_ids = ( dossiers_selected_ids !== "" ) ? dossiers_selected_ids.split('|') : [];

        if( isGroupeFlux === "oui" && obj_ids.length > 1 ){
            execute("lancerFluxDossiers" , "OPS_flux");
        }else{
            if( obj_ids.length > 0 ){
                for ( var key in obj_ids ) {
                    ModalFlux.route('loading');
                    ModalFlux.loading.reset();
                    lancerFluxByDossier( obj_ids[key], obj_ids.length );
                }
            }
        }
    }else{
        $("#small_select_flux").text("Aucun flux n'est séléctionné").show();
        $("#select_flux").css('border', '1px solid red');
    }
}

LancerFlux.lancerFluxUnitaire = function(){
    var flux_id = $("#select_flux").children("option:selected").attr("id");
    if( flux_id !== undefined ){
        $("#tbody_resultat_flux").empty(); 
        $("#small_select_flux").hide();
        $("#select_flux").css('border', '1px solid green');
        ModalFlux.route('loading');

        var loading = function(){
            ModalFlux.loading.setMessage('Lancement du flux');
        };

        var callBack = function(){

            var message = `Lancement du flux du dossier`;

            ModalFlux.loading.setMessage(message);
            ModalFlux.loading.setTotal(1);
            ModalFlux.loading.increaseCurrent();

            setTimeout(() => {
                ModalFlux.route('flux');
                ModalFlux.loading.reset();
                retourFunctionFlux.lancerFluxByDossier(this);
                $('#form_flux_unitaire_btn_terminer').text('Fermer');
                $('#form_flux_unitaire_btn_execute').hide();
            }, 1000);
            
        };

        var obj_json = { dossier_id: getIdDossier(), flux_id: $("#select_flux").children("option:selected").attr("id") };
        var data = ( isJson( JSON.stringify( obj_json ) ) ) ? utf8_to_b64( JSON.stringify( obj_json ) ) : false;
        var query = OdeQueries.getAjaxActionQuery();
        query.setModule('OPS_flux');
        query.setAction("lancerFluxByDossier");
        query.setPostData( data );
        OdeAjax.getByAction( query, loading, callBack );

        }else{
            $("#small_select_flux").text("Aucun flux n'est séléctionné").show();
            $("#select_flux").css('border', '1px solid red');
        }
}

LancerFlux.getSelectedDossiers = function(){
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
            json = $.parseJSON( json );
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    if (document.MassUpdate.uid.value != ''){
        var massUpdate = document.MassUpdate.uid.value;
        massUpdate += ',';
        massUpdate += tabId.join(',');
        tabId = massUpdate.split(',');
        if(tabId[tabId.length - 1] == ''){
            tabId.pop();
        }
    }
    return ( document.MassUpdate.select_entire_list.value == 1 ) ? { dossiers: false, filtres: json } : { dossiers: tabId, filtres: false };
}

var RoutingFlux = {

	route: function (form_name, data) {

        this.forms = this.forms || $('[role="form"]');
        if( this.forms.length === 0 ){ return false; }

        this.initFormulaire(form_name, data);
        this.displayFormulaire();

        return true;
    },

    initFormulaire: function (form_name, data) { 

        switch (form_name) {
            case "message_flux":
                Flux.initMessage(data);
                break;
            case "loading_flux":
                Flux.initLoading();
                break;
            case "progress_loading_flux":
                Flux.initProgressLoading();
                break;
            case "choix_flux":
                Flux.initChoix(data);
                break;
            case "resultat_flux":
                Flux.initResultat(data);
                break;
            case "choix_flux_unitaire":
                Flux.initChoixUnitaire(data);
                break;
            case "resultat_flux_unitaire":
                Flux.initResultatUnitaire(data);
                break;
            default:
                console.log("Formulaire "+form_name+" Non définie dans le Routing.")
                break;
        }

        this.forms.each( function() {  
            ( $(this).attr("data-name") === form_name ) ? $(this).attr("data-selected" , "true") : $(this).attr("data-selected" , "false");
        });  

    },

    displayFormulaire: function () { 
        this.forms.each( function() {
            ( $(this).attr("data-selected") === "true" ) ? $(this).show("fade", { direction: "right", align: "center" }, 500 ) : $(this).hide();
        });
    },
	
};


var Flux = {

    initMessage: function (data) {
        console.log("initMessage :: data = ", data)
    },

    initLoading: function () {
        LoadingFlux.addSpinner($('#modal_flux_loading'));
        $("#form_flux_btn_lancer").hide();
    },

    initProgressLoading: function () {
        ProgressBarFlux.initBar("flux_progress_bar");
        $("#form_flux_btn_lancer").hide();
    },

    initChoix: function (data) {

        var title = ( data.dossiers_selected.nb === 1 ) ? "Lancer un flux sur le dossier" : "Lancer un flux sur les "+data.dossiers_selected.nb+" dossiers"; 
        
        $("#form_flux_btn_lancer").show();
        $("#modal_flux_title").text( title );
        $("#dossiers_selected_nums").text( data.dossiers_selected.nums );
        $("#dossiers_selected_ids").val( data.dossiers_selected.ids );
        $("#small_select_flux").hide();
        $("#select_flux").css('border', '');
        $("#select_flux").empty();
        $("#select_flux").append('<option value=""></option>');
        if ( Object.keys(data.flux).length > 0 ) {
            modal_flux = data.flux;
            Object.keys(data.flux).forEach(function(flux_id) {
                $("#select_flux").append('<option id="'+ flux_id +'" data-is-lot="'+ data.flux[flux_id].is_lot +'" >'+ data.flux[flux_id].name +'</option>')
      
            });
        }
    },
    
    initResultat: function (data) {
    	if( data !== false ){
            var resultat = data;
                $("#tbody_resultat_flux").empty(); 
                $html_dossier =  '<tr>';
                $html_dossier +=    '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 45%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
                $html_dossier +=         resultat.dossiers;
                $html_dossier +=    '</td>';
                $html_dossier +=    '<td class="td-resultat-verification">';
                $html_dossier +=        ( data ) ? '<img style="width: 17px;" src="custom/include/images/success.png" />' : '<img style="width: 17px;" src="custom/include/images/delete.png" />';
                $html_dossier +=    '</td>';
                $html_dossier +=    '<td class="td-resultat-verification">';
                $html_dossier +=       resultat.data_retour;
                $html_dossier +=    '</td>';
                $html_dossier += '</tr>';
                $("#tbody_resultat_flux").append($html_dossier);
           
                ModalFlux.route('flux');
                RoutingFlux.route("resultat_flux", false);
                $('#form_flux_btn_terminer').text('Fermer');
                $('#form_flux_btn_execute').hide();
    	}
    },

    initChoixUnitaire: function (data) {
        $("#small_select_flux").hide();
        $("#flux_description").text("");
        $("#select_flux").css('border', '');
        $("#select_flux").empty();
        $("#select_flux").append('<option value=""></option>');
        if ( Object.keys(data.flux).length > 0 ) {
            modal_flux = data.flux;
            Object.keys(data.flux).forEach(function(flux_id) {
                $("#select_flux").append('<option id="'+ flux_id +'" data-is-lot="'+ data.flux[flux_id].is_lot +'" >'+ data.flux[flux_id].name +'</option>');
            });
        }
    },

    initResultatUnitaire: function (data) {

        var resultat = data.result;
        $("#tbody_resultat_flux").empty(); 
        $html_dossier =  '<tr>';
        $html_dossier +=    '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 45%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
        $html_dossier +=        '<a href="index.php?module=OPS_dossier&action=DetailView&record=' + resultat.dossier_id + '" target="_blank" style="color:'; 
        $html_dossier +=         ( data.statut === true ) ? '#003a6c;">' : 'red;">';
        $html_dossier +=         resultat.dossier_name + '</a>';
        $html_dossier +=    '</td>';
        $html_dossier +=    '<td class="td-resultat-verification">';
        $html_dossier +=        ( data.statut === true  ) ? '<img style="width: 17px;" src="custom/include/images/success.png" />' : '<img style="width: 17px;" src="custom/include/images/delete.png" />';
        $html_dossier +=    '</td>';
        $html_dossier +=    '<td class="td-resultat-verification">';
        $html_dossier +=       resultat.data_retour;
        $html_dossier +=    '</td>';
        $html_dossier += '</tr>';
        $("#tbody_resultat_flux").append($html_dossier);

    },

}

function onChangeFlux(){

    $("#flux_description").text("");
    var flux_id = $("#select_flux").children("option:selected").attr("id");
    if( flux_id !== undefined && Object.keys(modal_flux).length > 0 && modal_flux.hasOwnProperty(flux_id) ){
        $("#flux_description").text( modal_flux[flux_id].description );
    }

}

var LoadingFlux = {

    addSpinner: function (el, static_pos){
        var spinner = el.children('.spinner');
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};

function lancerFluxByDossier( dossier_id, dossiers_length ){

    var loading = function(){
        ModalFlux.loading.setMessage('Lancement du flux');
    };

    var callBack = function(){

        var message = ( dossiers_length === 1 ) 
                    ? `Lancement du flux du dossier séléctionné`
                    : `Lancement du flux des ${dossiers_length} dossiers séléctionnés`;

        ModalFlux.loading.setMessage(message);
        ModalFlux.loading.setTotal(dossiers_length);

        retourlancerFluxByDossier( this, dossiers_length )
    };

    var obj_json = { dossier_id: dossier_id, flux_id: $("#select_flux").children("option:selected").attr("id") };
    var data = ( isJson( JSON.stringify( obj_json ) ) ) ? utf8_to_b64( JSON.stringify( obj_json ) ) : false;
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_flux');
    query.setAction("lancerFluxByDossier");
    query.setPostData( data );
    OdeAjax.getByAction( query, loading, callBack );
    
}

function retourlancerFluxByDossier( reponse, dossiers_length ){

    var resultat = reponse.result;

    $html_dossier = '';
    $html_dossier += '<tr>';
    $html_dossier +=    '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 45%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
    $html_dossier +=        '<a href="index.php?module=OPS_dossier&action=DetailView&record=' + resultat.dossier_id + '" target="_blank" style="color:'; 
    $html_dossier +=         ( reponse.statut === true ) ? '#003a6c;">' : 'red;">';
    $html_dossier +=         resultat.dossier_name + '</a>';
    $html_dossier +=    '</td>';
    $html_dossier +=    '<td class="td-resultat-verification">';
    $html_dossier +=        ( reponse.statut === true ) ? '<img style="width: 17px;" src="custom/include/images/success.png" />' : '<img style="width: 17px;" src="custom/include/images/delete.png" />';
    $html_dossier +=    '</td>';
    $html_dossier +=    '<td class="td-resultat-verification">';
    $html_dossier +=       resultat.data_retour;
    $html_dossier +=    '</td>';
    $html_dossier += '</tr>';
    $("#tbody_resultat_flux").append($html_dossier);

    ModalFlux.loading.increaseCurrent();

    if( ModalFlux.loading.total === dossiers_length ){
        time = 2000 + (dossiers_length * 1000);
        setTimeout(function (){
            ModalFlux.route('flux');
            RoutingFlux.route("resultat_flux", false);
            $('#form_flux_btn_terminer').text('Fermer');
            $('#form_flux_btn_execute').hide();
        }, time); 
    }

}

var ProgressBarFlux = {

    currentValue: 0,
    currentDone: 0,
    barContent: false,

    initBar: function( bar_content_id ){
        this.barContent = ( $("#"+bar_content_id).length > 0 ) ? $("#"+bar_content_id) : false;
        this.reset();
    },

    reset: function () {
        this.currentValue = 0;
        this.currentDone = 0;
        if(this.barContent){
            this.barContent.css("width","0%");
        }
    },

    increaseDone(){
        this.currentDone = this.currentDone + 1;
    },

    animate: function ( value ) {
        value = Math.floor( value );
        if( this.barContent !== false && typeof value === "number" && value > 0 ){
            if( this.currentValue + value > 100 ){
                value = 100 - this.currentValue;
            }
            this.currentValue += value;
            this.barContent.css("width",`${this.currentValue}%`);
        }
    }

}

function getIdDossier(){
    var searchParams = new URLSearchParams(location.search);
    return ( searchParams.get("record") ) ? searchParams.get("record") : "";
}

// Fonction qui retourne la liste des dossiers 
function getDossiers(){

    var dossiers = false;
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    dossiers = tabId + '&selectAll=0';
    if (document.MassUpdate.select_entire_list.value == 1) {
        dossiers = json + '&selectAll=1';
    }
    return dossiers;

}


var getDataFunctionFlux = {
    initChoixFlux: function() {
        var dossiers = getDossiers();
        return ( typeof dossiers === "string" &&  Object.keys(dossiers).length > 0 ) ? "dossiers=" + dossiers : false;
    },
    lancerFluxDossiers: function() {
        var obj_json = { 
            dossiers_ids: $("#dossiers_selected_ids").val(),
            flux_id: $("#select_flux").children("option:selected").attr("id") 
        };
        return ( isJson( JSON.stringify( obj_json ) ) ) ? "json=" + utf8_to_b64( JSON.stringify( obj_json ) ) : false;
    },
    initChoixUnitaire: function() {
        var dossier_id = getIdDossier();
        return ( typeof dossier_id === "string" ) ? {dossier_id : dossier_id} : false;
    },
    lancerFluxByDossier: function() {
        var flux_id = $("#select_flux").children("option:selected").attr("id") 
        if( flux_id !== undefined ){
            var obj_json = { 
                dossier_id: getIdDossier(),
                flux_id: flux_id
            };
            return ( isJson( JSON.stringify( obj_json ) ) ) ? "json=" + utf8_to_b64( JSON.stringify( obj_json ) ) : false;
        }else{
            $("#small_select_flux").text("Aucun flux n'est séléctionné").show();
            $("#select_flux").css('border', '1px solid red');
            return false;
        }
    },
    
};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionFlux : Object.assign(getDataFunction, getDataFunctionFlux);


// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionFlux = {
    initChoixFlux: function() {
        RoutingFlux.route("loading_flux", null);
    },
    lancerFluxDossiers: function() {
        RoutingFlux.route("loading_flux", null);
    },
    initChoixUnitaire: function() {
        RoutingFlux.route("loading_flux", null);
    },    
    lancerFluxByDossier: function() {
        RoutingFlux.route("loading_flux", null);
    },
};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionFlux : Object.assign(loadingFunction, loadingFunctionFlux);


// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionFlux = {
    initChoixFlux: function(data) {
        if(data){
            if( data['statut'] === true ){
                RoutingFlux.route( "choix_flux", data.result );
            } else {
                RoutingFlux.route( "message_flux", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingFlux.route( "message_flux", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    lancerFluxDossiers: function(data) {
        if(data){
            if( data['statut'] === "ok" ){
                RoutingFlux.route( "resultat_flux", data.data );
            } else {
                RoutingFlux.route( "message_flux", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingFlux.route( "message_flux", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    initChoixUnitaire: function(data) {
        if(data){
            if( data['statut'] === true ){
                RoutingFlux.route( "choix_flux_unitaire", data.result );
            } else {
                RoutingFlux.route( "message_flux", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingFlux.route( "message_flux", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    lancerFluxByDossier: function(data) {
        if(data){
            RoutingFlux.route( "resultat_flux_unitaire", data );
        }else{
            RoutingFlux.route( "message_flux", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionFlux : Object.assign(retourFunction, retourFunctionFlux);
