$(document).ready(function() {

    // We initialize the modal
    ModalExportFormulaire.initialisation( ExportFormulaire.modal_id );

    if ( ModalExportFormulaire.loaded ) {

        // We initialize the onclick function [ Action par lot ]
        ExportFormulaire.setClickActionLotBtn();
    }

    $('#form_formulaire_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_formulaire_btn_exporter').click(function(){
        var form = decodeURIComponent(escape(window.atob(  jQuery('#tab_formulaires').val() )));
        download("modeles_dossiers.json", form );
        $.f_modal.close();

    });

});

// We create an instance of the OdeModal object
const ModalExportFormulaire = Object.create(OdeModal);

if( typeof(ExportFormulaire) == 'undefined' ){ var ExportFormulaire = { modal_id: 'ode_modal_export_formulaire', loaded: false }; }

// We initialize the onclick function [ Action par lot ]
ExportFormulaire.setClickActionLotBtn = function(){
    $('[role="ode-modal-formulaire-btn"]').off().on('click', function () {
        $('#form_formulaire_btn_terminer').text('Annuler');
        $('#form_formulaire_btn_terminer').show();
        ModalExportFormulaire.initialisation( ExportFormulaire.modal_id );
        ModalExportFormulaire.open();
        ExportFormulaire.initialisation();
    });
}

ExportFormulaire.initialisation = function(){ 

    ModalExportFormulaire.route('loading');

    var loading = function(){
        ModalExportFormulaire.loading.setMessage('Récupération des formulaires séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalExportFormulaire.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result === "string" && this.result != '' ){
            ModalExportFormulaire.route('erreur',this.result);
            $('#form_formulaire_btn_terminer').show();
            $('#form_formulaire_btn_terminer').text('Fermer');
            $('#form_formulaire_btn_exporter').hide();
            return; 
        }


        var message = ( this.result.nb === 1 ) 
                    ? `Récupération du formulaire séléctionné`
                    : `Récupération des ${this.result.nb} formulaires séléctionnés`;

        ModalExportFormulaire.loading.setMessage(message);
        ModalExportFormulaire.loading.setTotal(this.result.nb);

        for(var i = 0; i < this.result.nb; i++){
            ModalExportFormulaire.loading.increaseCurrent();
        }

        setTimeout(() => {
            ModalExportFormulaire.route('formulaire');
            ModalExportFormulaire.loading.reset();
            retourFunctionExportFormulaires.initFormulaireExport(this);
        }, 1000);
    };

    var formulaires = ExportFormulaire.getSelectedformulaires();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_generateur_formulaire');
    query.setAction("initFormulaireExport");
    query.setPostData( formulaires );
    OdeAjax.getByAction( query, loading, callBack );
}

function download(filename, text) {
    var element = document.createElement('a');
    element.setAttribute('href', 'data:application/json;charset=utf-8,' + encodeURIComponent(text));
    element.setAttribute('download', filename);

    element.style.display = 'none';
    document.body.appendChild(element);
    element.click();
    document.body.removeChild(element);
}

ExportFormulaire.getSelectedformulaires = function(){
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
            json = $.parseJSON( json );
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    return ( document.MassUpdate.select_entire_list.value == 1 ) ? { formulaires: false, filtres: json } : { formulaires: tabId, filtres: false };
}

var RoutingexportFormulaires = {

    route: function (form_name, data) {
        this.forms = this.forms || $('[role="form"]');
        if( this.forms.length === 0 ){ return false; }
        this.initFormulaire(form_name, data);
        this.displayFormulaire();
        return true;
    },

    initFormulaire: function (form_name, data) { 

        switch (form_name) {
            case "resultat_export_formulaire":
                exportFormulaires.initResultat(data);
                break;
            case "message_export_formulaire":
                exportFormulaires.initMessage(data);
                break;
            case "loading_export_formulaire":
                exportFormulaires.initLoading();
                break;
            case "formulaire_export_formulaire":
                exportFormulaires.initFormulaire( data );
                break;
            default:
                console.log("Formulaire "+form_name+" Non définie dans le Routing.")
                break;
        }

        this.forms.each( function() {  
            ( $(this).attr("data-name") === form_name ) ? $(this).attr("data-selected" , "true") : $(this).attr("data-selected" , "false");
        });  

    },

    displayFormulaire: function () { 
        this.forms.each( function() {
            ( $(this).attr("data-selected") === "true" ) ? $(this).show("fade", { direction: "right", align: "center" }, 500 ) : $(this).hide();
        });
    },
    
};

var exportFormulaires = {
  
    initLoading: function () {
        LoadingexportFormulaires.addSpinner($('#modal_export_formulaire_loading'));
        $("#form_formulaire_btn_exporter").hide();
    },

    initFormulaire: function ( data ) {
        if( data !== null){
            const formulaires = data.formulaires;
            var formulaire_html = '';
            var tab_id ="";
            formulaire_html += '<ul class="list-group list-group-flush">';
            if ( Object.keys(formulaires).length > 0 ){
                Object.keys(formulaires).forEach(function(formulaire_id) {
                    const form = formulaires[formulaire_id];
                    formulaire_html += '<li class="list-group-item">'+ form.name +'</li>';
                    tab_id += formulaire_id + ";";
                });
            }

            formulaire_html += '</ul>';
            formulaire_html += '<textarea style="display:none" id="tab_formulaires">'+data.download+'</textarea>';

            $("#formulaire_export_formulaire").empty();
            $("#formulaire_export_formulaire").append(formulaire_html);
        }
        
        $("#form_formulaire_btn_exporter").show();
    },

    initMessage: function ( data ) {
        $('#message_export_formulaire_titre').empty();
        $('#message_export_formulaire_message').empty();
        $('#message_export_formulaire_html_message').empty();
        if( typeof data.titre === "string" ) $("#message_export_formulaire_titre").text( data.titre );
        if( typeof data.message === "string" ) $("#message_export_formulaire_message").text( data.message );
        if( typeof data.html_message === "string" ) $("#message_export_formulaire_html_message").append(data.html_message);
    },

}

var LoadingexportFormulaires = {

    addSpinner: function (el, static_pos){
        var spinner = el.children('.spinner');
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};

// Fonction qui retourne la liste des formulaires 
function getformulaires(){

    var formulaires = false;
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    formulaires = tabId + '&selectAll=0';
    if (document.MassUpdate.select_entire_list.value == 1) {
        formulaires = json + '&selectAll=1';
    }
    return formulaires;

}

// Cette variable regroupe les differentes fonctions des get données pour l'envoie Ajax
var getDataFunctionExportFormulaire = {
    initFormulaireExport: function() {
        var formulaires = getformulaires();
        return ( typeof formulaires === "string" && Object.keys(formulaires).length > 0 ) ? "formulaires=" + formulaires : false;
    }
};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionExportFormulaire : Object.assign(getDataFunction, getDataFunctionExportFormulaire);

// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionExportFormulaire = {
    initFormulaireExport: function() {
        RoutingexportFormulaires.route("loading_export_formulaire", null);
    }
};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionExportFormulaire : Object.assign(loadingFunction, loadingFunctionExportFormulaire);

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionExportFormulaires = {
    initFormulaireExport: function(data) {
        var titre = "Erreur d'initilisation du formulaire";
        if(data){
            if ( data['statut'] === true ) {
                RoutingexportFormulaires.route( "formulaire_export_formulaire", data['result'] );
            } else {
                var message = data['data'];
                RoutingexportFormulaires.route( "message_export_formulaire", { titre: titre, message: message, html_message: null } ); 
            } 
        }else{
            RoutingexportFormulaires.route( "message_export_formulaire", { titre: titre, message: " Erreur de communication avec le serveur, veuillez contacter votre administrateur.",html_message: null } ); 
        }
        
    },
};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionExportFormulaires : Object.assign(retourFunction, retourFunctionExportFormulaires);

