<?php

use ODE\Model\GenerateurVueModel;
use ODE\Model\GenerateurReferentielModel;

class OPS_generateur_vue extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_generateur_vue';
    public $object_name = 'OPS_generateur_vue';
    public $table_name = 'ops_generateur_vue';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $cle;
    public $type_demandeur;
    public $module;

    public function bean_implements($interface)
    {
        switch ($interface) {
            case 'ACL':
                return true;
        }

        return false;
    }

    /**
     * @access public
     * @name create()
     * Fonction qui crée une vue avec onglets et lignes
     *
     *  @return string               - $vue_id : l'id de la vue créer
     */
    public function update($onglets)
    {
        foreach ($onglets as $onglet_id => $onglet) {
            $obj_onglet = BeanFactory::getBean('OPS_generateur_onglet', $onglet_id);
            if (!empty($obj_onglet->id)) {
                $obj_onglet->name = $onglet["nom"];
                $obj_onglet->libelle = $onglet["libelle"];
                $obj_onglet->cle = $onglet["cle"];
                $obj_onglet->ordre = $onglet["ordre"];
                $obj_onglet->save();
                GenerateurVueModel::deleteLignes($obj_onglet->id);
                if (is_array($onglet["lignes"]) && count($onglet["lignes"]) > 0) {
                    $obj_onglet->createLignes($onglet["lignes"]);
                }
            }
        }
    }

    /**
     * @access public
     * @name create()
     * Fonction qui crée une vue avec onglets et lignes
     *
     *  @return string               - $vue_id : l'id de la vue créer
     */
    public static function getDefault($type, $formulaire_name)
    {
        global $app_list_strings;

        $obj_vue = BeanFactory::newBean('OPS_generateur_vue');

        if($type === "crm"){
            $libelle = " [Vue Agent] - ";
        } else if ($type === "internet"){
            $libelle = "[Vue Usager] - ";
        } else {
            # Surcharge module Partenaire
            if (isset($app_list_strings['moduleList']['OPS_avis'])) {
                $libelle = "[Vue Partenaire] - ";
            } else {
                $libelle = "[Vue Usager] - ";
            }
            # Fin surcharge module Partenaire
        }
        $obj_vue->name = $libelle . $formulaire_name;
        $vue_id = $obj_vue->save();

        $obj_onglet = BeanFactory::newBean('OPS_generateur_onglet');
        $obj_onglet->name = "onglet_1";
        $obj_onglet->libelle = "Onglet " . $type . " 1";
        $obj_onglet->cle = "OGL1";
        $obj_onglet->ordre = "1";
        $onglet_id = $obj_onglet->save(false);

        $obj_vue->load_relationship('ops_generateur_vue_ops_generateur_onglet');
        $obj_vue->ops_generateur_vue_ops_generateur_onglet->add($onglet_id);

            $obj_champ_1 = BeanFactory::newBean('OPS_generateur_champ');
            $obj_champ_1->ligne = 0;
            $obj_champ_1->ordre = 0;
            $obj_champ_1->type = "vide";
            $champ_1_id = $obj_champ_1->save(false);

            $obj_champ_2 = BeanFactory::newBean('OPS_generateur_champ');
            $obj_champ_2->ligne = 0;
            $obj_champ_2->ordre = 1;
            $obj_champ_2->type = "vide";
            $champ_2_id = $obj_champ_2->save(false);

            $obj_onglet->load_relationship('ops_generateur_onglet_ops_generateur_champ');
            $obj_onglet->ops_generateur_onglet_ops_generateur_champ->add($champ_1_id);
            $obj_onglet->ops_generateur_onglet_ops_generateur_champ->add($champ_2_id);

        return $vue_id;
    }


    public function getOnglets()
    {

        $onglets = [];
        $vue_onglets = $this->get_linked_beans("ops_generateur_vue_ops_generateur_onglet", "OPS_generateur_onglet");
        foreach ($vue_onglets as $onglet) {
            $onglets[$onglet->ordre] = [
                "id" => $onglet->id,
                "nom" => $onglet->name,
                "libelle" => $onglet->libelle,
                "cle" => $onglet->cle,
                "conditions" => $onglet->conditions,
                "description" => $onglet->description,
                "visible" => $onglet->visible,
                "modifiable" => $onglet->modifiable,
                "lignes" => $onglet->getChamps()
            ];
        }
        ksort($onglets);
        return $onglets;
    }

    /**
     * @access public
     * @name getListOnglets()
     * Fonction qui retourne la liste des onglets liés au module triée par ordre 
     *
     *  @return array|boolean               - $list : liste des onglets ou false
     */
    public function getListOnglets()
    {

        $list = false;
        $tab_onglet = array();
        $tab_onglet_bis = array();
        $onglets = $this->get_linked_beans("ops_generateur_vue_ops_generateur_onglet", "OPS_generateur_onglet");

        foreach ($onglets as $onglet) {
            if (array_key_exists($onglet->ordre, $tab_onglet) === false && is_numeric($onglet->ordre)) {
                $tab_onglet[$onglet->ordre]['id'] = $onglet->id;
                $tab_onglet[$onglet->ordre]['name'] = $onglet->name;
                $tab_onglet[$onglet->ordre]['libelle'] = $onglet->libelle;
                $tab_onglet[$onglet->ordre]['cle'] = $onglet->cle;
                $tab_onglet[$onglet->ordre]['champs'] = $this->getChampsOnglet($onglet);
            } else {
                $tab_onglet_bis[$onglet->id]['id'] = $onglet->id;
                $tab_onglet_bis[$onglet->id]['name'] = $onglet->name;
                $tab_onglet_bis[$onglet->id]['libelle'] = $onglet->libelle;
                $tab_onglet_bis[$onglet->id]['cle'] = $onglet->cle;
                $tab_onglet[$onglet->ordre]['champs'] = $this->getChampsOnglet($onglet);
            }
        }

        ksort($tab_onglet);

        foreach ($tab_onglet_bis as $onglet) {
            $tab_onglet[] = $onglet;
        }

        if (is_array($tab_onglet) && count($tab_onglet) > 0) {
            $list = $tab_onglet;
        } else {
            $list = $this->initNewOnglet();
        }

        return $list;
    }

    /**
     * @access public
     * @name initNewOnglet()
     * Fonction qui initialise un nouvel onglet
     *
     *  @return array               - $onglet: format tableau 
     */
    public function initNewOnglet()
    {

        $onglet = new OPS_generateur_onglet;
        $onglet->name = "defaut";
        $onglet->libelle = "Défaut";
        $onglet->cle = "dft";
        $onglet->ordre = 1;
        $id = $onglet->save(false);

        $this->load_relationship('ops_generateur_vue_ops_generateur_onglet');
        $this->ops_generateur_vue_ops_generateur_onglet->add($id);

        $tab_onglet[$onglet->ordre] = array(
            'id' => $onglet->id,
            'name' => $onglet->name,
            'libelle' => $onglet->libelle,
            'cle' => $onglet->cle,
            'champs' => $this->getChampsOnglet($onglet),
        );

        return $tab_onglet;
    }

    /**
     * @access public
     * @name getChampsOnglet()
     * Fonction qui retourne la liste des champs de l'onglet par ligne et par ordre 
     *
     *  @return array|boolean               - $list : liste des onglets ou false
     */
    public function getChampsOnglet($onglet)
    {

        $champs = array();
        $liste_champs = $onglet->get_linked_beans("ops_generateur_onglet_ops_generateur_champ", "OPS_generateur_champ");
        foreach ($liste_champs as $key => $champ) {
            $champs[$champ->ligne][$champ->ordre] = array(
                "name" => $champ->name,
                "libelle" => $champ->libelle,
                "obligatoire" => ($champ->obligatoire == 1) ? 1 : 0,
                "type" => $champ->type,
                "cle" => $champ->cle,
                "ineditable" => ($champ->ineditable == 1) ? 1 : 0,
                "aide" => $champ->aide,
                "defaut" => $champ->defaut,
                "description" => $champ->description,
                "params" => $champ->params,
                "conditions" => $champ->conditions,
                "modifiable" => ($champ->modifiable == 0) ? 0 : 1
            );
        }
        ksort($champs);
        return $champs;
    }

    /**
     * @access public
     * @name getChampsVue()
     * Fonction qui retourne la liste des champs de l'onglet par ligne et par ordre 
     *
     *  @return array|boolean               - $list : liste des onglets ou false
     */
    public function getChampsVue()
    {

        $champs = array();
        $onglets = $this->get_linked_beans("ops_generateur_vue_ops_generateur_onglet", "OPS_generateur_onglet");
        foreach ($onglets as $onglet) {
            $liste_champs = $onglet->get_linked_beans("ops_generateur_onglet_ops_generateur_champ", "OPS_generateur_champ");
            foreach ($liste_champs as $champ) {
                if (!empty($champ->name)) {
                    $champs[] = $champ->name;
                }
            }
        }
        return $champs;
    }

    /**
     * @access public
     * @name getArrayFormat()
     * Fonction qui retourne le formulaire en tableau
     *
     *  @return array|boolean               - $formulaire : tableau formulaire
     */
    public function getArrayFormat()
    {

        $formulaire = array(
            'name' => (!empty($this->name)) ? $this->name : "",
            'cle' => (!empty($this->cle)) ? $this->cle : "",
            'module' => (!empty($this->module)) ? $this->module : "",
            'type_document' => array()
        );

        $onglets = $this->get_linked_beans("ops_generateur_vue_ops_generateur_onglet", "OPS_generateur_onglet");
        if (is_array($onglets) && count($onglets) > 0) {
            foreach ($onglets as $onglet) {
                $champsOnglet = $onglet->getChamps();
                $formulaire['onglets'][] = array(
                    'name' => $onglet->name,
                    'libelle' => $onglet->libelle,
                    'cle' => $onglet->cle,
                    'ordre' => $onglet->ordre,
                    "conditions" => $onglet->conditions,
                    'champs' => $champsOnglet
                );
                foreach ($champsOnglet as $ligne) {
                    foreach ($ligne as $champ) {
                        if($champ['type'] === 'file' && !empty($champ['params'])){
                            $params = json_decode(base64_decode($champ['params']),true);
                            if(!empty($params)){
                                $typeDocumentObj = BeanFactory::getBean('OPS_type_document',$params['attache']);
                                $formulaire['type_document'][$typeDocumentObj->id] = array(
                                    'name' => $typeDocumentObj->name,
                                    'statut' => $typeDocumentObj->statut,
                                    'objet' => $typeDocumentObj->objet,
                                    'taille_limite' => $typeDocumentObj->taille_limite,
                                    'multi_fichier' => $typeDocumentObj->multi_fichier,
                                    'format_multiselect' => $typeDocumentObj->format,
                                    'identifiant' => $typeDocumentObj->identifiant
                                );
                            }
                        }
                    }
                }
            }
        }

        return $formulaire;
    }
}
