<?php

use ODE\Helper\OdeArrayHelper;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


class OPS_guide_instructionController extends SugarController
{


    /**
     * @access public
     * action_importerJson()
     * Fonction pour importer un guide d'instruction avec ses étapes et statuts
     *
     * @return json     $data
     */
    function action_importerJson()
    {
        global $app_list_strings;

        $libelle_erreur = "";
        $resultat_creation = array();
        $statut = false;

        // Liste des champs à vérifier, true si c'est obligatoire
        $champs = array(
            "json" => true,
        );

        // Vérification des données recus dans  $_REQUEST
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {


            $guides = $data_verified['data']['json_array'];

            // On parcours les guides d'instruction 
            foreach ($guides as $guide_id => $guide) {

                $resultat_guide = array('name' => '', 'statut' => 'err', 'erreur' => '');

                // Vérification du nom du guide d'instruction
                if (empty($guide['name'])) {
                    $resultat_guide['name'] = "vide";
                    $resultat_guide['erreur'] = "Le nom du guide d'instruction est vide. ";
                    $resultat_creation[$guide_id] = $resultat_guide;
                } else {
                    $resultat_guide['name'] = ($this->isNameGuideExist($guide['name']) === true) ? $this->getNameGuide($guide['name']) : $guide['name'];
                }

                // Vérification du statut initial du guide d'instruction
                if (empty($guide['ops_statut_id'])) {
                    $resultat_guide['erreur'] = "Le guide d'instruction " . $guide['name'] . " ne dispose pas de statut initial. ";
                    $resultat_creation[$guide_id] = $resultat_guide;
                } else {
                    $resultat_guide['statut'] = 'ok';
                }

                if ($resultat_guide['statut'] === 'ok') {

                    // Création du guide d'instruction
                    $new_guide = BeanFactory::newBean('OPS_guide_instruction');
                    $new_guide->name = $resultat_guide['name'];
                    $new_guide->description = $guide['description'];
                    $new_guide->save();

                    $resultat_creation[$new_guide->id] = $resultat_guide;

                    // On garde l'id du statut initial en mémoire. 
                    $ops_statut_id = $guide['ops_statut_id'];

                    $correspondance_etapes = array();

                    // On parcours les étapes du guide d'instruction
                    foreach ($guide['etapes'] as $etape_id => $etape) {

                        $new_etape = BeanFactory::newBean('OPS_etape');
                        $new_etape->name = $etape['name'];
                        $new_etape->description = $etape['description'];
                        $new_etape->ordre = $etape['ordre'];
                        $new_etape->retour_arriere = $etape['retour_arriere'];
                        $new_etape->instruction = html_entity_decode(base64_decode($etape['instruction']));

                        if(isset($app_list_strings['moduleList']['OPS_avis'])){
                            $new_etape->visible_partenaire = $etape['visible_partenaire'];
                            $new_etape->libelle_partenaire = $etape['libelle_partenaire'];
                        }

                        // J'affecte l'ancien id de l'étape précedente et je reboucle à la fin pour les remplacer avec les nouveaux
                        $new_etape->ops_etape_id = $etape['ops_etape_id'];
                        $new_etape->save();

                        // Je stock l'ancien id de l'étape et son nouveau id pour remplacer les étapes précedentes à la fin de l'opération
                        $correspondance_etapes[$etape_id]['id'] = $new_etape->id;

                        // On crée la relation guide instruction <-> etape
                        $new_guide->load_relationship('ops_guide_instruction_ops_etape');
                        $new_guide->ops_guide_instruction_ops_etape->add($new_etape);

                        // On parcours les statuts de l'étape
                        foreach ($etape['statuts'] as $statut_id => $statut) {

                            $new_statut = BeanFactory::newBean('OPS_statut');
                            $new_statut->name = $statut['name'];
                            $new_statut->description = $statut['description'];
                            $new_statut->ordre = $statut['ordre'];
                            $new_statut->code_couleur = $statut['code_couleur'];
                            $new_statut->avancement = $statut['avancement'];
                            $new_statut->nom_statut_gru = $statut['nom_statut_gru'];

                            $new_statut->visible_usager    = $statut['visible_usager'];
                            $new_statut->libelle_usager    = $statut['libelle_usager'];
                            $new_statut->modifiable_usager = $statut['modifiable_usager'];
                            $new_statut->dossier_incomplet = $statut['dossier_incomplet'];

                            if(isset($app_list_strings['moduleList']['OPS_avis'])){
                                $new_statut->ops_statut_completude_partenaire_id = $statut['ops_statut_completude_partenaire_id'];
                                $new_statut->visible_partenaire = $statut['visible_partenaire'];
                                $new_statut->modifiable_partenaire = $statut['modifiable_partenaire'];
                                $new_statut->libelle_partenaire = $statut['libelle_partenaire'];
                                $new_statut->demande_paiement_autorise_partenaire = $statut['demande_paiement_autorise_partenaire'];
                            }

                            $new_statut->save();

                            $correspondance_etapes[$etape_id]['statuts'][$statut_id]['id'] = $new_statut->id;

                            if ($ops_statut_id === $statut_id) {
                                $new_guide->ops_statut_id = $new_statut->id;
                                $new_guide->save();
                            }

                            // On crée la relation etape <-> statut
                            $new_etape->load_relationship('ops_etape_ops_statut');
                            $new_etape->ops_etape_ops_statut->add($new_statut);

                            foreach ($statut['action_statuts'] as $action_statut_id => $action_statut) {
                                $new_action_statut = BeanFactory::newBean('OPS_action_statut');
                                foreach ($action_statut as $action_statut_key => $value) {
                                    $new_action_statut->{$action_statut_key} = $value;
                                }
                                $new_action_statut->save();
                                // On crée la relation statut <-> action_statut
                                $new_statut->load_relationship('ops_action_statut_ops_statut');
                                $new_statut->ops_action_statut_ops_statut->add($new_action_statut);
                            }
                        }
                    }

                    // Toutes les étapes ont été créees, on boucle pour affecter les étapes précedentes
                    foreach ($correspondance_etapes as $old_etape_id => $new_etape) {
                        $obj_etape = BeanFactory::getBean('OPS_etape', $new_etape['id']);
                        if (!empty($obj_etape->id)) {
                            // Si l'étape dispose d'une étape précedente, on remplace l'id par le nouveau 
                            if (!empty($obj_etape->ops_etape_id)) {
                                if (array_key_exists($obj_etape->ops_etape_id, $correspondance_etapes)) {
                                    $obj_etape->ops_etape_id = $correspondance_etapes[$obj_etape->ops_etape_id]['id'];
                                    $obj_etape->save();
                                }
                            }
                        }
                    }
                }
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si les guides d'instruction on bien été crées on retourne le résultat de l'opération
        $data = (is_array($resultat_creation) && count($resultat_creation) > 0) ? array('statut' => 'ok', 'data' => array('guides' => $resultat_creation)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * action_exporterJson()
     * Fonction pour exporter un guide d'instruction avec ses étapes et statuts
     *
     * @return json     $data
     */
    function action_exporterJson()
    {
        global $app_list_strings;

        $guides = array();
        $libelle_erreur = "";

        // Liste des champs à vérifier, true si c'est obligatoire
        $champs = array(
            "json" => true,
        );

        // Vérification des données recus dans  $_REQUEST
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $json_array = $data_verified['data']['json_array'];
            if (is_array($json_array['guides']) && count($json_array['guides']) > 0) {

                foreach ($json_array['guides'] as $guide_id) {

                    // On récupere le guide d'instruction
                    $obj_guide = BeanFactory::getBean('OPS_guide_instruction', $guide_id);
                    if (!empty($obj_guide->id)) {

                        $guides[$obj_guide->id]['name'] = $obj_guide->name;
                        $guides[$obj_guide->id]['description'] = $obj_guide->description;
                        $guides[$obj_guide->id]['ops_statut_id'] = $obj_guide->ops_statut_id;

                        // On récupere les étapes liées au guide d'instruction
                        $etapes = $obj_guide->get_linked_beans("ops_guide_instruction_ops_etape", "OPS_etape");
                        if (is_array($etapes) &&  count($etapes) > 0) {
                            foreach ($etapes as $etape) {
                                if (in_array($etape->id, $json_array['etapes'])) {
                                    $guides[$obj_guide->id]['etapes'][$etape->id] = array(
                                        'name' => $etape->name,
                                        'description' => $etape->description,
                                        'ordre' => $etape->ordre,
                                        'retour_arriere' => $etape->retour_arriere,
                                        'ops_etape_id' => $etape->ops_etape_id,
                                        'instruction' => base64_encode(htmlentities($etape->instruction)),
                                    );

                                    if(isset($app_list_strings['moduleList']['OPS_avis'])){
                                        $guides[$obj_guide->id]['etapes'][$etape->id]['visible_partenaire'] = $etape->visible_partenaire;
                                        $guides[$obj_guide->id]['etapes'][$etape->id]['libelle_partenaire'] = $etape->libelle_partenaire;
                                    }

                                    // On récupere les statuts liés à l'étape
                                    $statuts = $etape->get_linked_beans("ops_etape_ops_statut", "OPS_statut");
                                    if (is_array($statuts) &&  count($statuts) > 0) {
                                        foreach ($statuts as $statut) {

                                            if (in_array($statut->id, $json_array['statuts'])) {
                                                $guides[$obj_guide->id]['etapes'][$etape->id]['statuts'][$statut->id] = array(
                                                    'name' => $statut->name,
                                                    'description' => $statut->description,
                                                    'ordre' => $statut->ordre,
                                                    'code_couleur' => $statut->code_couleur,
                                                    'avancement' => $statut->avancement,
                                                    'nom_statut_gru' => $statut->nom_statut_gru,
                                                    'visible_usager' => $statut->visible_usager,
                                                    'libelle_usager' => $statut->libelle_usager,
                                                    'modifiable_usager' => $statut->modifiable_usager,
                                                    'dossier_incomplet' => $statut->dossier_incomplet
                                                );

                                                if(isset($app_list_strings['moduleList']['OPS_avis'])){
                                                    $guides[$obj_guide->id]['etapes'][$etape->id]['statuts'][$statut->id]['ops_statut_completude_partenaire_id'] = $statut->ops_statut_completude_partenaire_id;
                                                    $guides[$obj_guide->id]['etapes'][$etape->id]['statuts'][$statut->id]['visible_partenaire'] = $statut->visible_partenaire;
                                                    $guides[$obj_guide->id]['etapes'][$etape->id]['statuts'][$statut->id]['modifiable_partenaire'] = $statut->modifiable_partenaire;
                                                    $guides[$obj_guide->id]['etapes'][$etape->id]['statuts'][$statut->id]['libelle_partenaire'] = $statut->libelle_partenaire;
                                                    $guides[$obj_guide->id]['etapes'][$etape->id]['statuts'][$statut->id]['demande_paiement_autorise_partenaire'] = $statut->demande_paiement_autorise_partenaire;
                                                }

                                                // On récupere les actions de statuts liés aux statuts
                                                $actionStatuts = $statut->get_linked_beans("ops_action_statut_ops_statut", "OPS_action_statut");
                                                if (is_array($actionStatuts) && count($actionStatuts) > 0) {
                                                    foreach ($actionStatuts as $actionStatut) {
                                                        $guides[$obj_guide->id]['etapes'][$etape->id]['statuts'][$statut->id]['action_statuts'][$actionStatut->id] = array(
                                                            'name' => $actionStatut->name,
                                                            'active' => $actionStatut->active,
                                                            'fonction' => $actionStatut->fonction,
                                                            'ext_valeur_1' => $actionStatut->ext_valeur_1,
                                                            'ext_valeur_2' => $actionStatut->ext_valeur_2,
                                                            'ext_valeur_3' => $actionStatut->ext_valeur_3,
                                                            'ext_valeur_4' => $actionStatut->ext_valeur_4,
                                                            'ext_valeur_5' => $actionStatut->ext_valeur_5,
                                                            'ext_valeur_6' => $actionStatut->ext_valeur_6,
                                                            'ext_valeur_text' => $actionStatut->ext_valeur_text,
                                                            'execution_retarde' => $actionStatut->execution_retarde,
                                                            'jours' => $actionStatut->jours,
                                                            'heures' => $actionStatut->heures,
                                                            'minutes' => $actionStatut->minutes,
                                                            'ordre' => $actionStatut->ordre
                                                        );
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                $libelle_erreur = "Aucun guide d'instruction à exporter.";
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si les guides d'instruction on bien été crées on retourne le résultat de l'opération
        $data = (is_array($guides) && count($guides) > 0) ? array('statut' => 'ok', 'data' => array('guides' => $guides)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }



    /**
     * @access public
     * action_initFormulaireExport()
     * Fonction qui renvoie les parametres necessaires à l'initialisation de la modal export guide d'instruction
     *
     */
    function action_initFormulaireExport()
    {

        $libelle_erreur = '';
        $resultat = array();

        $data_verified = $this->getGuides($_REQUEST);
        if ($data_verified['statut'] == 'ok') {

            $guides = $data_verified['data']['guides'];
            if (is_array($guides) && count($guides) > 0) {
                foreach ($guides as $guide_id) {
                    // On récupere le guide d'instruction
                    $guide = BeanFactory::getBean('OPS_guide_instruction', $guide_id);
                    if (!empty($guide->id)) {
                        $resultat[$guide->id]['name'] = $guide->name;
                        // On récupere les étapes liées au guide d'instruction
                        $etapes = $guide->get_linked_beans("ops_guide_instruction_ops_etape", "OPS_etape");
                        if (is_array($etapes) &&  count($etapes) > 0) {
                            foreach ($etapes as $etape) {
                                $resultat[$guide->id]['etapes'][$etape->id]['name'] = $etape->name;
                                // On récupere les statuts liés à l'étape
                                $statuts = $etape->get_linked_beans("ops_etape_ops_statut", "OPS_statut");
                                if (is_array($statuts) &&  count($statuts) > 0) {
                                    foreach ($statuts as $statut) {
                                        $resultat[$guide->id]['etapes'][$etape->id]['statuts'][$statut->id]['name'] = $statut->name;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        if (is_array($resultat) && count($resultat) > 0) {
            $sort = array();
            foreach ($resultat as $k => $v) {
                $sort['name'][$k] = $v['name'];
            }
            array_multisort($sort['name'], SORT_ASC, $resultat);
        }

        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => array('guides' => $resultat)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access private
     * getGuides()
     * Fonction qui vérifie les données avant traitement
     *
     */
    private function getGuides($request)
    {

        global $db;
        $array_retour = array();
        // Je ne vérifie pas si $request['selectAll'] est non vide, empty($request['selectAll']) retourne true quand $request['selectAll']=0
        if (isset($request['selectAll']) && isset($request['guides']) && !empty($request['guides'])) {
            if ($request['selectAll'] == 1) {

                // Ce traitement est utilisé dans le cas ou l'utilisateur sélectionne l'intégralité des guides + filtres
                $json = html_entity_decode($request['guides']);
                $obj_guide = new OPS_guide_instruction();
                $mass = new MassUpdate();
                $mass->generateSearchWhere('OPS_guide_instruction', $json);
                $where_clause = $mass->where_clauses;
                $query = $obj_guide->create_export_query($order_by, $where_clause);
                $result = $db->query($query);
                $guides = "";
                while ($quotes = $db->fetchByAssoc($result)) {
                    $guides .= $quotes['id'] . ",";
                }
                $array_retour['guides'] = (strpos($guides, ',') !== false) ? explode(",", $guides) : array(0 => $guides);
            } else {
                $array_retour['guides'] = (strpos($request['guides'], ',') !== false) ? explode(",", $request['guides']) : array(0 => $request['guides']);
            }
        } else return ['statut' => 'err', 'data' => 'Aucun guide d\'instruction n\'a été récupéré'];

        return ['statut' => 'ok', 'data' => $array_retour];
    }

    /**
     * @access private
     * isNameGuideExist()
     * Fonction qui vérifie si le champs du guide existe deja en BDD
     * 
     * @param string                  $guide_name: le nom du guide
     * @return boolean                $exist: true ou false
     */
    private function isNameGuideExist($guide_name)
    {
        $exist = false;
        $obj_guide = new OPS_guide_instruction;
        $liste_guides = $obj_guide->get_full_list();
        foreach ($liste_guides as $guide) {
            if ($guide_name === $guide->name) $exist = true;
        }
        return $exist;
    }

    /**
     * @access private
     * formateNameGuide()
     * Fonction qui retourne le nom du guide formaté 
     * 
     * @param string                  $guide_name: le nom du guide
     * @return boolean                $exist: true ou false
     */
    function formateNameGuide($guide_name)
    {
        if (strpos($guide_name, "(") !== false) {
            $guide_name = explode("(",  $guide_name)[0];
        }
        return strtolower(str_replace(" ", "", trim($guide_name)));
    }

    /**
     * @access private
     * getNameGuide()
     * Fonction qui retourne le nom du guide avec incrémentation si il existe
     * 
     * @param string                  $guide_name: le nom du guide
     * @return boolean                $new_guide_name: le nouveau nom du guide
     */
    private function getNameGuide($guide_name)
    {

        $name_result = "";
        $guide_names = array();
        $obj_guide = new OPS_guide_instruction;
        $liste_guides = $obj_guide->get_full_list();
        foreach ($liste_guides as $guide) {
            $name_formated = $this->formateNameGuide($guide->name);
            if (array_key_exists($name_formated, $guide_names)) {
                $guide_names[$name_formated]++;
            } else {
                $guide_names[$name_formated] = 1;
            }
        }

        if (array_key_exists($this->formateNameGuide($guide_name), $guide_names)) {
            $name_without_bracket = (strpos($guide_name, "(") !== false) ? explode("(",  $guide_name)[0] : $guide_name;
            $name_result = $name_without_bracket . " (" . $guide_names[$this->formateNameGuide($guide_name)] . ")";
        }

        return (!empty($name_result)) ? $name_result : $guide_name;
    }
}
