<?php


class OPS_habilitation_dispositif extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_habilitation_dispositif';
    public $object_name = 'OPS_habilitation_dispositif';
    public $table_name = 'ops_habilitation_dispositif';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $visualisation;
    public $instruction;
    public $edition;
    public $suppression;
    public $assignation;
    
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    /**
     * get_habilitations
     * Fonction de récupération des habilitations dispositifs 
     *
     *
     * @return tab_habilitations
     */
   public function get_habilitations() {

        global $app_list_strings, $beanFiles, $current_user ;

        $tab_habilitations = array() ; 

        $tab_habilitations['visualisation'] = $this->visualisation;
        $tab_habilitations['instruction']   = $this->instruction;
        $tab_habilitations['edition']       = $this->edition;
        $tab_habilitations['suppression']   = $this->suppression;
        $tab_habilitations['assignation']   = $this->assignation;
        $tab_habilitations['correction']    = $this->correction;
        $tab_habilitations['execution']     = $this->execution;
        $tab_habilitations['duplication']   = $this->duplication;

        // Vérification si les droits sur le dispositif concerne aussi les étapes : 
        $this->load_relationship('ops_habilitation_etape_ops_habilitation_dispositif');
        $etapes_ids = $this->ops_habilitation_etape_ops_habilitation_dispositif->get();

        // Récupération des droits sur les étapes 
        if( !empty($etapes_ids) )
        {
            // Boucle habilitation étapes 
            foreach ($etapes_ids as $etape_cle => $etape_id) 
            {
                $obj_habilitation_etape = BeanFactory::getBean('OPS_habilitation_etape', $etape_id);

                if( !empty($obj_habilitation_etape->ops_etape_id) )
                {
                    $tab_habilitations['etapes'][$obj_habilitation_etape->ops_etape_id] = $obj_habilitation_etape->get_habilitations_etapes();
                }
            }
        }

        return $tab_habilitations ; 

    }

    function get_view_etapes($ops_dispositif_id){ 

        $html =   "<div id='vue_etapes'>";
        
        // Récupération des étapes du guide d'instruction
        if( !empty($ops_dispositif_id) ){

    
            // Récupération des étapes déjà parametrées
            $habilitation_etapes = $this->get_habilitations();

            $obj_dispositif = new OPS_dispositif();
            $obj_dispositif->retrieve( $ops_dispositif_id );

            $obj_guide_instruction = new OPS_guide_instruction();
            $obj_guide_instruction->retrieve( $obj_dispositif->ops_guide_instruction_id );

            if( !empty($obj_guide_instruction->id) ){

                $tab_etapes = $obj_guide_instruction->liste_etapes();

                if( !empty($tab_etapes) ){

                    // Création de l'entête 
                    $html .=   "<div id='vue_etapes' class='tab-content' style='margin-right:15%'>";
                    $html .=   "<p class='suppression' style='float:right;margin-left:  15%;'>Suppression</p>";
                    $html .=   "<p class='edition' style='float:right;margin-left: 15%;'>Édition</p>";
                    $html .=   "<p class='instruction' style='float:right;margin-left:  15%;'>Instruction</p>";
                    $html .=   "<p class='visualisation' style='float:right;margin-left: 15%;'>Visualisation</p>";
                    $html .=   "</div>";
                    
                    foreach ($tab_etapes as $key => $etape) {

                        $flag = array();  
                        $ids[] =   $etape['id'] ;
                      
                        if( isset( $habilitation_etapes['etapes'][$etape['id']] )  && !empty($habilitation_etapes['etapes'][$etape['id']])){

                            foreach ($habilitation_etapes['etapes'][$etape['id']] as $cle => $tag) {
                                if( $tag == true ){
                                    $flag[$cle] = "checked";
                                }

                            }

                        }

                        $html .=   "<div class='tab-content' style='margin-right:17%; margin-top:0'>";
                        $html .=  $etape['name'] . ":"; 
                        $html .= "<input style='float:right;margin-left:  20%;' class='suppression' type='checkbox' id='".$etape['id']."_suppression' name='".$etape['id']."_suppression' value='1' ". $flag['suppression'] .">";
                        $html .= "<input style='float:right;margin-left:  19%;' class='edition' type='checkbox' id='".$etape['id']."_edition' name='".$etape['id']."_edition' value='1' ". $flag['edition'] .">";
                        $html .= "<input style='float:right;margin-left:  20%;' class='instruction' type='checkbox' id='".$etape['id']."_instruction' name='".$etape['id']."_instruction' value='1' ". $flag['instruction'] .">";
                        $html .= "<input style='float:right;margin-left:  20%;' class='visualisation' type='checkbox' id='".$etape['id']."_visualisation' name='".$etape['id']."_visualisation' value='1' ". $flag['visualisation'] .">";
                        $html .=   "</div>";

                    }  

                    $liste_ids = implode(",", $ids);
                    $html .= "<input type='hidden' value='".$liste_ids."' name='etapes_ids'>";
                           
                }
                else{

                    $html .=   "<div class='tab-content'>Aucune étape sur le guide d'instruction</div>";
                }
            }
            else{

                $html .=   "<div class='tab-content'>Veuillez séléctionner un guide d'instruction sur votre dispositif</div>";
            }
        }
        else{ 

            $html .=  "<div class='tab-content'>Veuillez séléctionner un dispositif</div>";
        }
        
        $html .=   "</div>";
 
        return $html ; 

    }
    

    public function mark_deleted($id)
    {

        $this->load_relationship('ops_habilitation_etape_ops_habilitation_dispositif');
        $etapes_ids = $this->ops_habilitation_etape_ops_habilitation_dispositif->get();

        if( !empty($etapes_ids) ){

            // Boucle habilitation étapes 
            foreach ($etapes_ids as $etape_cle => $etape_id) {

                $obj_habilitation_etape = BeanFactory::getBean('OPS_habilitation_etape', $etape_id);
                $obj_habilitation_etape->mark_deleted($etape_id);

               
            }
        }
        
        parent::mark_deleted($id);

    }
}