$(document).ready(function() {

    var apiBanDisabled = Boolean(getApiBan());


    if( $('#habilitation_individu').val() !== undefined && $('#habilitation_individu').val() != '')
    {
        var habilitation_individu = JSON.parse( atob( $("#habilitation_individu").val() ) );

        if(habilitation_individu.admin != true)
        {
            if( habilitation_individu.autorisations_attestations != 1 )
            {
                $('#tab1').remove();
                $('.hidden-xs #tab1').remove();
                $('#tab-content-1').empty();
            }
            if( habilitation_individu.fiche_sante != 1 )
            {
                $('#tab2').remove();
                $('.hidden-xs #tab2').remove();
                $('#tab-content-2').empty();
            }
            if( habilitation_individu.situation_professionnelle != 1 )
            {
                $('#tab4').remove();
                $('.hidden-xs #tab4').remove();
                $('#tab-content-4').empty();
            }
            if( habilitation_individu.regime_alimentaire != 1 )
            {
                $('#tab5').remove();
                $('.hidden-xs #tab5').remove();
                $('#tab-content-5').empty();
            }
            if( habilitation_individu.journal_modification != 1 )
            {
                $('#btn_view_change_log').remove();
            }
        }
    }
    else
    {
        $('#tab1').remove();
        $('.hidden-xs #tab1').remove();
        $('#tab-content-1').empty();

        $('#tab2').remove();
        $('.hidden-xs #tab2').remove();
        $('#tab-content-2').empty();

        $('#tab4').remove();
        $('.hidden-xs #tab4').remove();
        $('#tab-content-4').empty();

        $('#tab5').remove();
        $('.hidden-xs #tab5').remove();
        $('#tab-content-5').empty();

        $('#btn_view_change_log').remove();
    }

    $('[role=section_title]').each(function() {
        $(this).closest('.edit-view-row-item').find('> .label').hide();
        $(this).text( $(this).closest('.edit-view-row-item').find('> .label').text().replaceAll(':', '') );
        $(this).show();
    });
    
    getOnlget();

    apply_phone_mask("#phone_mobile");
    select_on_focus("#phone_mobile");

    apply_phone_mask("#phone_home");
    select_on_focus("#phone_home");

    apply_phone_mask("#phone_work");
    select_on_focus("#phone_work");

    apply_phone_mask("#phone_other");
    select_on_focus("#phone_other");

    $('#type_individu').click(function(){
        getOnlget();
    });

    $('#first_name').keyup(function(){
        $(this).val($(this).val().charAt(0).toUpperCase() + $(this).val().substring(1).toLowerCase());
    });

    $('#last_name, #nom_usage').keyup(function(){
        $(this).val($(this).val().toUpperCase());
    });

    //Autocomplétion du code postal
    $('#address_postalcode, #primary_address_postalcode').autocomplete({
        minLength:3,
        disabled:apiBanDisabled,
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?postcode=" + $(self.element).val() + "&limit=25",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var villes = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.city, villes) == -1){
                            villes.push(item.properties.city);
                            var ville = item.properties.city;
                            var villeReg = ville.replace(/\s\d*[e]\sArrondissement/,'');
                            return {label: item.properties.postcode + " " + item.properties.city,
                                    city: villeReg,
                                    value: item.properties.postcode
                                };
                        }
                    }));
                }
            });
        },
        select: function(event,ui)
        {
            var ville = '';
        	if($(event.target).attr('id') == 'address_postalcode'){
        		ville = 'address_city';
        	}else{
        		ville = 'primary_address_city';
        	}
            $('#'+ville).val(ui.item.city);
        }
    });

    //Autocomplétion de la ville
    $('#address_city, #primary_address_city').autocomplete({
        minLength:3,
        disabled:apiBanDisabled,
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?q=" + $(self.element).val() + "&type=municipality&limit=20&autocomplete=1",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var villes = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.city, villes == -1)){
                            villes.push(item.properties.city);
                            var ville = item.properties.city;
                            var villeReg = ville.replace(/\s\d*[e]\sArrondissement/,'');
                            return {label: item.properties.postcode + " " + item.properties.city,
                                    postcode: item.properties.postcode,
                                    value: villeReg
                                };
                        }
                    }));
                }
            });
        },
        select: function(event,ui)
        {
            var postcode = '';
        	if($(event.target).attr('id') == 'address_city'){
        		postcode = 'address_postalcode';
        	}else{
        		postcode = 'primary_address_postalcode';
        	}
            $('#'+postcode).val(ui.item.postcode);
        }
    });

    //Autocomplétion de la voie
    $('#adresse_voie, #primary_address_street').autocomplete({
        minLength:3,
        disabled:apiBanDisabled,
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?q=" + $(self.element).val() + "&type=street&limit=10&autocomplete=1",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var voies = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.name, voies) == -1){
                            voies.push(item.properties.name);
                            return {label: item.properties.name,
                                    value: item.properties.name
                                };
                        }
                    }));
                }
            });
        }
    });
});


function verif_tel( type ){

    var estValide;
    var tel = document.getElementById(type).value ;
    
    tel = tel.replace(/ /gi , "");

    var valide=/^0[1-6]\d{8}$/;

    if( !valide.test(tel)){
        
        estValide = false;
  
    }
   

    if( estValide == false ){

        document.getElementById(type).style.backgroundColor = "red";

    }
    else{

        document.getElementById(type).style.backgroundColor = "#c3e7fd";

    }   

}


function getOnlget()
{
    if($('#type_individu').val() == 'adulte')
    {
        $('#tab1').hide();
        $('.hidden-xs #tab1').hide();
        $('#tab2').hide();
        $('.hidden-xs #tab2').hide();
        $('#tab4').show();
        $('.hidden-xs #tab4').show();
        $('#tab5').hide();
        $('.hidden-xs #tab5').hide();

        $('#tab-content-0 .edit-view-row-item .edit-view-field').each(function(i){
            $(this).closest('.edit-view-row-item').show();
        });

        $('#salutation').show();
        $('#sexe').hide();
    }
    else if($('#type_individu').val() == 'enfant')
    {
        $('#tab1').show();
        $('.hidden-xs #tab1').show();
        $('#tab2').show();
        $('.hidden-xs #tab2').show();
        $('#tab4').hide();
        $('.hidden-xs #tab4').hide();
        $('#tab5').show();
        $('.hidden-xs #tab5').show();

        $('#tab-content-0 .edit-view-row-item .edit-view-field').each(function(i){
            $(this).closest('.edit-view-row-item').show();
        });

        $('#salutation').hide();
        $('#sexe').show();

        $('#situation_familiale').closest('.edit-view-row-item').hide();
        $('#representant_parent').closest('.edit-view-row-item').hide();
    }
    else if($('#type_individu').val() == 'contact')
    {
        $('#tab1').hide();
        $('.hidden-xs #tab1').hide();
        $('#tab2').hide();
        $('.hidden-xs #tab2').hide();
        $('#tab4').hide();
        $('.hidden-xs #tab4').hide();
        $('#tab5').hide();
        $('.hidden-xs #tab5').hide();

        $('#salutation').show();
        $('#sexe').hide();

        var displays_field = ['autres_informations', 'last_name', 'first_name', 'nom_usage', 'type_individu', 'identite', 'assigned_user_name', 'canal', 'description'];
        $('#tab-content-0 .edit-view-row-item .edit-view-field').each(function(i){
            if(!displays_field.includes($(this).attr('field')) && $(this).find('[role="section_title"]').length == 0 )
            {
                $(this).closest('.edit-view-row-item').hide();
            }
            else
            {
                $(this).closest('.edit-view-row-item').show();
            }
        });
    }
    else
    {
        $('#tab1').hide();
        $('.hidden-xs #tab1').hide();
        $('#tab2').hide();
        $('.hidden-xs #tab2').hide();
        $('#tab4').hide();
        $('.hidden-xs #tab4').hide();
        $('#tab5').hide();
        $('.hidden-xs #tab5').hide();

        var displays_field = ['autres_informations', 'last_name', 'first_name', 'nom_usage', 'type_individu', 'identite', 'assigned_user_name', 'canal', 'description'];
        $('#tab-content-0 .edit-view-row-item .edit-view-field').each(function(i){
            if(!displays_field.includes($(this).attr('field')) && $(this).find('[role="section_title"]').length == 0 )
            {
                $(this).closest('.edit-view-row-item').hide();
            }
            else
            {
                $(this).closest('.edit-view-row-item').show();
            }
        });

        $('#salutation').show();
        $('#sexe').hide();

        $('#situation_familiale').show();
        $('#situation_familiale').parent().parent().children().first().show();
    }
}

/**
 * Applicateur de masque téléphone
 * 
 * @return void.
 */
function apply_phone_mask(input_field_selector) {
    var mask_array = ($(input_field_selector)[0].dataset.mask).split(',')
    jQuery(input_field_selector).inputmask({
        mask: mask_array,
        greedy: false,
        clearIncomplete: true,
        definitions: {
            'T': {
                validator: "[4]"
            },
            'Z': {
                validator: "[0]"
            },
            'V': {
                validator: "[8]"
            },
            'R': {
                validator: "[2]"
            },
            'W': {
                validator: "[2-3]"
            },
            'F': {
                validator: "[3]"
            },
            'M': {
                validator: "[7]"
            },
            'I': {
                validator: "[6]"
            },
            'C': {
                validator: "[1-5]"
            },
            'G': {
                validator: "[6-7]"
            },
            'D': {
                validator: "[9]"
            },
            'E': {
                validator: "[5]"
            }
        },
        onBeforePaste: function (pastedValue, opts) {
            // For paired 6, 8 and 10 numbers!
            if (String(pastedValue).trim().length == 6 || String(pastedValue).trim().length == 10) {
                pastedValue = String(pastedValue).trim();
                numbers = pastedValue.match(/[0-9]{2}/g);
                return numbers.join(".");
            }

            // For not paired 7, 9 numbers!
            if (String(pastedValue).trim().length == 7 || String(pastedValue).trim().length == 9) {
                pastedValue = '0' + String(pastedValue).trim();
                numbers = pastedValue.match(/[0-9]{2}/g);
                numbers[0] = String(parseInt(numbers[0]));
                return numbers.join(".");
            }

        }
    });
}

function select_on_focus(field) {
    $(field).on('focus active', function (e) {
        $(e.target).select();
    });
};


function getApiBan(){
	var apiBanDisabled = false;
	$.ajax({
		url: "index.php",
        data: {
            module: 'OPS_individu',
            action: 'getApiBan',
        },
		async:false,
		success: function(data){
			apiBanDisabled = JSON.parse(data).apiBanDisabled;

		}
	});

	return apiBanDisabled;


}