<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class OPS_periodeController extends SugarController
{
    public function action_importerJoursFerie()
    {
        $done = false;
        if (isset($_POST['year']) && !empty($_POST['year'])) {
            try {

                $annee = date("Y");
                if ($_POST['year'] == 'next') {
                    $annee += 1;
                }

                // Récupération des jours fériés via l'api gouv
                $url = "https://calendrier.api.gouv.fr/jours-feries/metropole/{$annee}.json";
                $data = file_get_contents($url);
                $daysList = json_decode($data, true);

                $dateFormat = explode(' ', $GLOBALS['timedate']->get_date_time_format())[0] ?: 'Y-m-d';

                foreach ($daysList as $date => $name) {

                    $dateFormated = date($dateFormat, strtotime($date));

                    $objPeriode = BeanFactory::newBean("OPS_periode");
                    $where = 'ops_periode.type_periode = "ferie" AND ops_periode.date_debut = "' . $date . '" AND ops_periode.date_fin = "' . $date . '"';
                    $periodeListe = $objPeriode->get_list(limit: 1, where: $where);

                    if ($periodeListe['row_count'] == 0) {
                        $objPeriode->name = $name . " " . $annee;
                        $objPeriode->type_periode = 'ferie';
                        $objPeriode->active = 1;
                        $objPeriode->filtre = 0;
                        $objPeriode->date_debut = $dateFormated;
                        $objPeriode->date_fin = $dateFormated;

                        $objPeriode->save();
                    }
                }

                $done = true;
            } catch (Exception $e) {
                $GLOBALS['log']->fatal(__CLASS__ . '::' . __FUNCTION__ . ' => '  . __LINE__ . PHP_EOL . 'Une erreur est survenu : ' . $e, true);
            }
        }

        ob_clean();
        echo json_encode($done);
        sugar_cleanup(true);
    }
}
