<?php


require_once('include/SugarObjects/templates/company/Company.php');
require_once('include/EmailInterface.php');


class OPS_personne_morale extends Company implements EmailInterface
{
    public $new_schema = true;
    public $module_dir = 'OPS_personne_morale';
    public $object_name = 'OPS_personne_morale';
    public $table_name = 'ops_personne_morale';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $ops_personne_morale_type;
    public $industry;
    public $annual_revenue;
    public $phone_fax;
    public $billing_address_street;
    public $billing_address_street_2;
    public $billing_address_street_3;
    public $billing_address_street_4;
    public $billing_address_city;
    public $billing_address_state;
    public $billing_address_postalcode;
    public $billing_address_country;
    public $rating;
    public $phone_office;
    public $phone_alternate;
    public $website;
    public $ownership;
    public $employees;
    public $ticker_symbol;
    public $shipping_address_street;
    public $shipping_address_street_2;
    public $shipping_address_street_3;
    public $shipping_address_street_4;
    public $shipping_address_city;
    public $shipping_address_state;
    public $shipping_address_postalcode;
    public $shipping_address_country;
    public $email1;
    public $email_addresses_primary;
    public $email_addresses;
    public $email_addresses_non_primary;
    public $sigle;
    public $logo;
    public $tiers_appaire;
    public $financeur;
    public $siret;
    public $reference;
    public $numero_rna;
    public $numero_rne;
    public $statut;
    public $date_declaration;
    public $code_ape;
    public $canal;
    public $effectif;
    
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }
    
    // Verification de l'unicite dans le cas d'une création et d'une modification
    public function verif_unicite() {

        global $db, $mod_strings, $app_list_strings;

        $message = "Le profil existe déjà, doublon détecté sur : <br>";
        $return_message = "" ; 
        /*
         * Verification de l'unicité sur l'ensemble des champs du tableau
        */  
        foreach ($app_list_strings['ops_personne_morale_controle_unicite'] as $key => $value) {

            $requete_base = "SELECT id, name FROM ops_personne_morale WHERE deleted=0 AND id !='".$this->id."' ";
            
            if (!empty($this->{$key})) {
                $search = array('-','_',' ');
                $clef = str_replace($search, '', $this->{$key});
                $requete = $requete_base." AND (UPPER(TRIM(REPLACE( REPLACE( REPLACE( `".$key."`, '_', ''), ' ', ''), '-', ''))) like '".$db->quote(strtoupper ( $clef ) ) ."')";

                $resultat = $db->query($requete);
                $nb_result = $db->getRowCount($resultat);
                if ($nb_result != 0) {
                    $message .= translate('LBL_'.strtoupper($key),'OPS_personne_morale'). " <br>";
                    $return_message = $message;

                }
                unset($resultat);
            }

        }

        return $return_message;
    }    
    

    // Récupération des profils en fonction d'un id individu
    public function get_profil_by_individu($id_individu){

        global $db, $app_list_strings;

        $rowResults = array();

        if( !empty($id_individu) ){

             $requete = $db->query("
            SELECT  ops_personne_morale.id, 
                    ops_personne_morale.name,
                    ops_personne_morale.date_declaration as date_declaration_visu,
                    ops_personne_morale.numero_rna as numero_rna_visu,
                    ops_personne_morale.siret as siret_visu,
                    ops_personne_morale.numero_rne as numero_rne_visu,
                    ops_personne_morale.code_ape as code_ape_visu,
                    ops_personne_morale.objet_social as objet_social_visu,
                    ops_personne_morale.sigle as sigle_visu,
                    ops_personne_morale.phone_office as phone_office_visu,
                    ops_personne_morale.website as website_visu,
                    ops_personne_morale.nature as nature_visu,
                    ops_personne_morale.billing_address_state,
                    ops_personne_morale.billing_address_number,
                    ops_personne_morale.billing_address_street,
                    ops_personne_morale.billing_address_complement,
                    ops_personne_morale.billing_address_complement_lieu,
                    ops_personne_morale.billing_address_city,
                    ops_personne_morale.billing_address_state,
                    ops_personne_morale.billing_address_postalcode,
                    ops_personne_morale.billing_address_country,
                    ops_personne_morale.billing_coordonnees_x,
                    ops_personne_morale.billing_coordonnees_y,

                    ops_personne_morale.effectif as effectif_profil_key,
                    ops_personne_morale.forme_juridique as forme_juridique_profil_key,
                    ops_personne_morale.secteur_activite as secteur_activite_profil_key,
                    ops_type_personne.id as id_type,
                    ops_type_personne.name as type_profil,
                    ops_type_personne.libelle_usager,
                    ops_type_personne.forme_juridique as forme_juridique_visu,
                    ops_type_personne.forme_juridique_liste as forme_juridique,
                    ops_type_personne.couleur,
                    ops_type_personne.icone,
                    ops_type_personne.api,
                    ops_personne_morale_individu.responsable,
                    ops_personne_morale_individu.role
            FROM ops_personne_morale, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu ,ops_personne_morale_individu, ops_type_personne_ops_personne_morale, ops_type_personne
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_individu_id =  '" . $id_individu . "'
            AND ops_personne_morale_individu.acces_usager = 1
            AND ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
            AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
            AND ops_personne_morale.deleted = 0
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_type_personne_ops_personne_morale.deleted = 0
            AND ops_type_personne.deleted = 0
            AND ops_type_personne.visible_usager = 1
            ORDER BY `ops_personne_morale`.`name` ASC ");
        
            $rowResults = array();
            while ($row = $db->fetchRow($requete)) {
                $obj_module = BeanFactory::getBean('OPS_personne_morale', $row['id']);

                // On récupère les justificatifs au statut "perime", "non_fourni" et/ou "rejete"
                $tab_justificatif = $obj_module->get_linked_beans(
                    field_name: 'ops_personne_morale_ops_justificatif', 
                    bean_name: 'ops_justificatif', 
                    order_by: 'depot ASC, date_entered DESC',
                    optional_where: 'statut IN("perime", "non_fourni", "rejete")'
                );

                // Si il y a au moins 1 justificatif a ce statut, on déclare le filtre sur le profil
                if(!empty($tab_justificatif)) {
                    $row['actions_requises'] = 'justificatif_a_fournir';
                } else {
                    $row['actions_requises'] = '';
                }

                if (!empty($row['forme_juridique'])) {
                    $row['forme_juridique'] = $app_list_strings['ops_forme_juridique_list'][$row['forme_juridique']];
                }
                if (!empty($row['nature_visu'])) {
                    $row['nature'] = $app_list_strings['ops_type_profil_nature_list'][$row['nature_visu']];
                }

                $row['email1'] = $obj_module->email1;
                $rowResults[$row['id']] = $row;
            }


        }
        
       return $rowResults;

    }

    public static function get_field_list($isGenerateur = false)
    {
        $liste_champs = [
            'identite' => [
                'libelle' => 'LBL_IDENTITE',
                'champs' => [
                    'type_tier'        => array(),
                    'nature'           => array(),
                    'name'             => array(),
                    'siret'            => array(),
                    'numero_rna'       => array(),
                    'numero_rne'       => array(),
                    'num_tahiti'       => array(),
                    'code_ape'         => array(),
                    'forme_juridique'  => array(),
                    'date_declaration' => array(),
                    'sigle'            => array(),
                ],
            ],
            'autres_informations' => [
                'libelle' => 'LBL_AUTRES_INFORMATIONS',
                'champs' => [
                    'effectif'           => array(),
                    'website'            => array(),
                    'flag_partenaire'    => array(),
                    'objet_social'       => array(),
                    'situation_handicap' => array(),
                    'secteur_activite'   => array(),
                    'assigned_user_name' => array(),
                    'canal'              => array(),
                    'description'        => array(),
                ],
            ],
            'annuaire' => [
                'libelle' => 'LBL_ONGLET_30',
                'champs' => [
                    'publie'                => array(),
                    'thematique'            => array(),
                    'accroche'              => array(),
                    'description_annuaire'  => array(),
                    'activites'             => array(),
                    'tarifs'                => array(),
                    'public_beneficiaire'   => array(),
                ],
            ],
            'agrement_relation' => [
                'libelle' => 'LBL_ONGLET_20',
                'champs' => [
                    'agrement_administratif' => array(),
                    'detail_agrement'        => array(),
                    'utilite_publique'       => array(),
                    'date_utilite_publique'  => array(),
                    'affiliee_reseau'        => array(),
                    'detail_affiliation'     => array(),
                ],
            ],
            'informations_fiscales' => [
                'libelle' => 'LBL_ONGLET_50',
                'champs' => [
                    'regime_allocataire' => array(),
                    'numero_allocataire' => array(),
                    'qf_caf_actuel'      => array(),
                    'qf_ville_actuel'    => array(),
                    'bon_msa'            => array(),
                    'date_application'   => array(),
                ],
            ],
            'moyens_contact' => [
                'libelle' => 'LBL_ONGLET_60',
                'champs' => [
                    'email1'                           => array(),
                    'phone_office'                     => array(),
                    'billing_address_number'           => array(),
                    'billing_address_street'           => array(),
                    'billing_address_complement'       => array(),
                    'billing_address_complement_lieu'  => array(),
                    'billing_address_postalcode'       => array(),
                    'billing_address_city'             => array(),
                    'billing_coordonnees_x'            => array(),
                    'billing_coordonnees_y'            => array(),
                    'adresse_date_validite'            => array(),
                    'adresse_hors_commune'             => array(),
                    'shipping_address_number'          => array(),
                    'shipping_address_street'          => array(),
                    'shipping_address_complement'      => array(),
                    'shipping_address_complement_lieu' => array(),
                    'shipping_address_postalcode'      => array(),
                    'shipping_address_city'            => array(),
                    'shipping_address_coordonnees_x'   => array(),
                    'shipping_address_coordonnees_y'   => array(),
                ],
            ],
        ];

        if($isGenerateur){
            $liste_champs['moyens_contact']['champs'] = [
                'email1'                => array(),
                'phone_office'          => array(),
                'adresse_domiciliation' => array(),
                'adresse_date_validite' => array(),
                'adresse_hors_commune'  => array(),
                'adresse_facturation'   => array(),
            ];
        }

        foreach ($liste_champs as $onglet_key => $onglet)
        {
            $liste_champs[$onglet_key]['libelle'] = translate($onglet['libelle'], 'OPS_personne_morale');

            foreach ($onglet['champs'] as $key => $champ) 
            {
                $liste_champs[$onglet_key]['champs'][$key]['name'] = $key;

                $liste_champs[$onglet_key]['champs'][$key]['libelle'] = translate('LBL_'.strtoupper($key),'OPS_personne_morale'); 
            }
        }

        return $liste_champs;
    }

    public function getCoordinates($address) {
        // Formatage de l'adresse
        $query_parts = [
            'street' => strtoupper(trim($address['street'])),
            'postal' => substr(intval(trim($address['postalcode'])), 0, 5),
            'city' => strtoupper(trim($address['city'])),
            'country' => strtoupper(trim($address['country']))
        ];
        
        // Nettoyage basique des caractères spéciaux
        foreach ($query_parts as &$part) {
            $part = preg_replace('/[°._]/', '', $part);
            $part = preg_replace('/([\s]+)/', ' ', $part);
            $part = trim($part);
        }
    
        // Construction de la requête
        $query = urlencode($query_parts['street'] . ' ' . $query_parts['postal'] . ' ' . $query_parts['city'] . ' ' . $query_parts['country']);
        $url = 'https://api-adresse.data.gouv.fr/search/?q=' . $query . '&type=housenumber&autocomplete=0&postcode=' . $query_parts['postal'] . '&limit=1';

        // Appel à l'API
        $result = @file_get_contents($url);
        $data = json_decode($result, true);

        // Traitement du résultat
        if (isset($data['features'][0]['geometry']['coordinates'])) {
            return [
                'longitude' => $data['features'][0]['geometry']['coordinates'][0],
                'latitude' => $data['features'][0]['geometry']['coordinates'][1],
                'status' => 'valid'
            ];
        }
    
        return [
            'longitude' => '0',
            'latitude' => '0',
            'status' => 'error'
        ];
    }
    
}