$(document).ready(function() {

    $('[role=section_title]').each(function() {
        $(this).closest('.detail-view-row-item').find('> .label').hide();
        $(this).closest('.detail-view-field').attr("style", "background-color: rgb(0,0,0,0);width: 100%");
        $(this).text( $(this).closest('.detail-view-row-item').find('> .label').text().replaceAll(':', '') );
        $(this).parent().attr("style", "width: 100%");
        $(this).show();
    });

    loadObligatoires();

    var rows = $('.detail-view-row');

    $(rows).each(function(){
        var col1 = $(this).find('.col-1-label:visible ');
        var col2 = $(this).find('.col-2-label:visible ');

        if(col1.length == 0 && col2.length > 0)
        {
            col2.removeClass('col-2-label');
            col2.addClass('col-1-label');
        }
    });

    var libelle = getLibelle();

    if(libelle != '')
    {
        var label = $('div[field=name]').parent().children()[0];
        $(label).text( "\n" + libelle +  ':' + "\n");
    }

    if(!$('#agrement_administratif').is(':checked'))
    {
        $('#detail_agrement').parent().parent().hide()
    }

    if(!$('#utilite_publique').is(':checked'))
    {
        $('#date_utilite_publique').parent().parent().hide()
    }

    if(!$('#affiliee_reseau').is(':checked'))
    {
        $('#detail_affiliation').parent().parent().hide()
    }
});

function b64_to_utf8( str ) {
    return decodeURIComponent(escape(window.atob( str )));
}

Object.size = function(obj) {
    var size = 0, key;
    for (key in obj) {
        if (obj.hasOwnProperty(key)) size++;
    }
    return size;
};

function getObligatoires(){
    return ( $("#personne_morale_obligatoire").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_obligatoire").val() ) ) : {} ;
}

function getLibelle(){
    return ( $("#personne_morale_libelle_nom").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_libelle_nom").val() ) ) : {} ;
}

function loadObligatoires(){
    var obligatoires = getObligatoires();

    if(typeof obligatoires != "undefined" || obligatoires != null){

        if(obligatoires['code_ape'] == 'hidden'){
            $('#code_ape').parent().parent().hide();
        }

        if(obligatoires['numero_rne'] == 'hidden'){
            $('#numero_rne').parent().parent().hide();
        }

        if(obligatoires['numero_rna'] == 'hidden'){
            $('#numero_rna').parent().parent().hide();
        }
        if(obligatoires['num_tahiti'] == 'hidden'){
            $('#num_tahiti').parent().parent().hide();
        }
        if(obligatoires['siret'] == 'hidden'){
            $('#siret').parent().parent().hide();
        }

        if(obligatoires['objet_social'] == 'hidden'){
            $('#objet_social').parent().parent().hide();
        }

        if(obligatoires['sigle'] == 'hidden'){
            $('#sigle').parent().parent().hide();
        }

        if(obligatoires['website'] == 'hidden'){
            $('#website').parent().parent().hide();
        }

        if(obligatoires['forme_juridique'] == 'hidden'){
            $('#forme_juridique').parent().parent().hide();
        }

        if(obligatoires['effectif'] == 'hidden'){
            $('#effectif').parent().parent().hide();
        }

        if(obligatoires['nature'] == 'hidden'){
            $('#nature').parent().parent().hide();
        }

        if(obligatoires['date_declaration'] == 'hidden'){
            $('#date_declaration').parent().parent().hide();
        }

        if(obligatoires['situation_handicap'] == 'hidden'){
            $('#situation_handicap').parent().parent().hide();
        }

        if(obligatoires['adresse_date_validite'] == 'hidden'){
            $('#adresse_date_validite').parent().parent().hide();
        }
        if(obligatoires['adresse_hors_commune'] == 'hidden'){
            $('#adresse_hors_commune').parent().parent().hide();
        }
        
        if(obligatoires['secteur_activite'] == 'hidden'){
            $('#secteur_activite').parent().parent().hide();
        }

        if(obligatoires['display_relation'] == '0'){
            $('#tab1').hide();
            $('.hidden-xs #tab1').hide();
        }

        if(obligatoires['display_annuaire'] == '0'){
            $('#tab2').hide();
            $('.hidden-xs #tab2').hide();
        }

        if(obligatoires['display_formule'] == '0'){
            $('#tab3').hide();
            $('.hidden-xs #tab3').hide();
        }

        if(obligatoires['display_info_fiscales'] == '0'){
            $('#tab4').hide();
            $('.hidden-xs #tab4').hide();
        }
    }
}
