$(document).ready(function() 
{   
    let lignes = $('.tabform tr');
    $('.tabform tr').remove();

    let list_generalites_identite = [
        'name',
        'siret',
        'numero_rna',
        'numero_rne',
        'num_tahiti',
        'code_ape',
        'forme_juridique',
        'date_declaration',
        'sigle'
    ];

    let list_generalites_autre = [
        'effectif',
        'website',
        'flag_partenaire',
        'situation_handicap',
        'objet_social',
        'secteur_activite',
        'assigned_user_name',
        'canal',
        'description',
    ];

    let list_annuaire = [
        
        "publie",
        "thematique",
        "accroche",
        "description_annuaire",
        "activites",
        "tarifs",
        "public_beneficiaire",
        "image"
    ];

    let list_moyen_de_contact_domiciliation = [
        
        "billing_address_number",
        "billing_address_street",
        "billing_address_complement",
        "billing_address_complement_lieu",
        "billing_address_postalcode",
        "billing_address_city",
        "billing_coordonnees_x",
        "billing_coordonnees_y",
        "adresse_date_validite",
        "adresse_hors_commune"
    ];
    let list_moyen_de_contact_facturation = [
        'shipping_address_number',
        'shipping_address_street',
        'shipping_address_complement',
        'shipping_address_complement_lieu',
        'shipping_address_postalcode',
        'shipping_address_city',
        'shipping_address_coordonnees_x',
        'shipping_address_coordonnees_y', 
    ];


    // // Généralités
    $('.tabform tbody').append( build_section('Généralités', 20) );
    $('.tabform tbody').append( getLignes(lignes, 'ops_type_personne_ops_personne_morale_name') );
    $('.tabform tbody').append( getLignes(lignes, 'nature') );
    $('.tabform tbody').append( build_section('Identité', 14) );

    $(list_generalites_identite).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });
    $('.tabform tbody').append( build_section('Autres informations', 14) );
    $(list_generalites_autre).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });

    // Moyens de contact
    $('.tabform tbody').append( build_section('Annuaire', 20) );
    $(list_annuaire).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });


    // Moyens de contact
    $('.tabform tbody').append( build_section('Moyens de contact', 20) );
    $('.tabform tbody').append( getLignes(lignes, 'email1') );
    $('.tabform tbody').append( getLignes(lignes, 'phone_office') );

    $('.tabform tbody').append( build_section('Adresse de domiciliation', 14) );

    $(list_moyen_de_contact_domiciliation).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });

    $('.tabform tbody').append( build_section('Adresse de facturation', 14) );
    $(list_moyen_de_contact_facturation).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });
    

});

function getLignes(lignes, id)
{
    let matched_line = ''

    $(lignes).each(function() {
        if( $(this).children().find('span').find('input, select, textarea').attr('id') == id)
        {
            matched_line = this;
            return;
        }
    });

    return matched_line;
}

function build_section(titre, size)
{
    let section = '<tr><th colspan="2" style="padding: ' + size + 'px;font-size: ' + size + 'px;">' + titre + '</th></tr>';

    return section;
}