<?php


class hook_plage_ouverture
{
    // Variables statiques permettant d'éviter les boucles (performance)
    static $already_ran_init = false;
    static $already_ran_delete = false;

    /**
     * Création des exceptions générées par récurrence sur une plage d'ouverture
     * @param $bean
     * @param mixed $event
     * @param mixed $araguments
     */
    public function init_exceptions_recurrence(&$bean, $event, $arguments = null)
    {
        // On évite une boucle sur le hook après chaque save() de la plage d'ouverture courante (changement de "date_derniere_occurrence")
        if (self::$already_ran_init == true)
            return;
        self::$already_ran_init = true;

        if ($event != 'after_save') {
            return;
        }
        // Création uniquement si on les a activés et qu'on a mit autre chose que "toutes les semaines"
        if ($bean->recurrence_active == true && $bean->recurrence != "* * *" && $bean->date_derniere_occurrence == '' && $bean->deleted == false) {
            $bean->init_exceptions_recurrence();
            return true;
        }

        return;
    }

    /**
     * Si Modification d'une recurrence sur la plage d'ouverture
     * Suppresion des exceptions générées avec l'ancienne récurrence
     * @param $bean
     * @param mixed $event
     * @param mixed $araguments
     */
	public function delete_exceptions_recurrence(&$bean, $event, $arguments = null)
	{
		// On évite une boucle sur le hook après chaque save() de la plage d'ouverture courante (changement de "date_derniere_occurrence")
		if (self::$already_ran_delete == true)
			return;
		self::$already_ran_delete = true;

		switch ($event) {
			case 'before_save':

				$bool_date_recurrence_change = false;
				if (!empty($_POST['recurrence_date_deb'])) {

					// Récupération des dates de début de récurrence
					$date_bean = DateTime::createFromFormat("Y-m-d",$bean->fetched_row['recurrence_date_deb']);
					$date_post = DateTime::createFromFormat("d/m/Y",$_POST['recurrence_date_deb']);

					if ($date_bean != $date_post) {
						$bool_date_recurrence_change = true;
					}

				}

				// On vérifie que la recurrence a changée et qu'on est pas sur une création "initiale"
				if (
					($bean->fetched_row['recurrence'] != $_POST['recurrence']
						|| $bool_date_recurrence_change
						|| $bean->fetched_row['recurrence_active'] != $_POST['recurrence_active']
						|| $bean->fetched_row['jours'] != $_POST['jours'])
					&& $bean->fetched_row['recurrence_active'] == 1
				) {
					$bean->delete_exceptions_recurrence('changement_recurrence');
				}
				return true;
			case 'after_delete':
				$bean->delete_exceptions_recurrence('suppression_plage_ouverture');
				return true;
			default:
				return;
		}
	}
}