jQuery(document).ready(function () {

	// Gestion des validations des horaires
	addToValidate("EditView", 'a_partir_de', 'varchar', true, 'A partir de');
	addToValidate("EditView", 'jusqu_a', 'varchar', true, "Jusqu'à");

	// Gestion de la récurrence
	// On récupère le champ Recurrence déjà présent et on le remplace par le champ dans le tpl
	var parent_div = document.getElementById("recurrence").parentNode;
	document.getElementById("recurrence").parentNode.removeChild(document.getElementById("recurrence"));
	jQuery("#champ_recurrence").detach().appendTo(parent_div);
	document.getElementById("recurrence_text").id = "recurrence";

	// On rajoute une vérification sur les boutons de sauvegarde pour les récurrences & les horaires
	var list_save_button = document.querySelectorAll("[id=SAVE]");

	for (let i = 0; i < list_save_button.length; i++) {
		list_save_button[i].setAttribute(
			"onClick",
			"verif_recurrence(event);" + jQuery(list_save_button[i]).attr("onclick")
		);
	}

	// On affiche ou on cache le panneau "Recurrence" en fonction de la case à cocher "Activer la récurrence"
	document.getElementById("recurrence_active").addEventListener("change", (event) => {
			display_recurrence_panel();
		});

	display_recurrence_panel();

	// On rempli les recurrences avec les valeurs stockées sur le bean
	set_recurrences();

	// Lieu required
	addToValidate('EditView','ops_lieux_ops_plage_ouverture_name','varchar',true,'Lieu');
	jQuery('#ops_lieux_ops_plage_ouverture_name').closest('div').siblings('div')[0].innerHTML += '<span class=\"required\">*</span>';

});



// Gestion de l'affichage du panel de la recurrence
function display_recurrence_panel() {
	var div_recurrence_subpanel = document
		.getElementById("recurrence_date_deb")
		.closest(".panel.panel-default");

	if (document.getElementById("recurrence_active").checked) {
		addToValidate(
			"EditView",
			"recurrence_date_deb",
			"date",
			true,
			"Début de la récurrence"
		);
		div_recurrence_subpanel.style.display = null;
	} else {
		div_recurrence_subpanel.style.display = "none";
		removeFromValidate("EditView", "recurrence_date_deb");
	}
}

// On paramètre les récurrences à l'entrée dans la vue Edit
function set_recurrences() {
	var recurrence = document.getElementById("recurrence").value;
	var option_array = recurrence.split(" ");
	if (recurrence === ""){
		option_array = ["", "", ""];
	}

	document.getElementById("day").value = option_array[0];
	document.getElementById("week").value = option_array[1];
	document.getElementById("month").value = option_array[2];
	check_common_options();
}

// On vérifie le champ des récurrences et on prépare la sauvegarde de la valeur
function verif_recurrence(event) {
	

	if (
		document.getElementById("day").value !== "" ||
		document.getElementById("week").value !== "" ||
		document.getElementById("month").value !== ""
	) {

		if (
			document.getElementById("day").value === "" ||
			document.getElementById("week").value === "" ||
			document.getElementById("month").value === ""
		) {
			if (document.getElementById("day").value === "") {
				document.getElementById("day").value = "*";
			}
			if (document.getElementById("week").value === "") {
				document.getElementById("week").value = "*";
			}
			if (document.getElementById("month").value === "") {
				document.getElementById("month").value = "*";
			}
		}


		document.getElementById("recurrence").value =
			document.getElementById("day").value +
			" " +
			document.getElementById("week").value +
			" " +
			document.getElementById("month").value;

	}

	// Si vide
	if(		
		document.getElementById("day").value.trim() === "" &&
		document.getElementById("week").value.trim() === "" &&
		document.getElementById("month").value.trim() === ""
	) {
		document.getElementById("recurrence").value = "* * *";

	}
}

// Lors de la sélection d'une option, on paramètre la valeur dans le champ text à gauche
function select_option(field) {
	
	var option = document.getElementById(field + "_options").value;
	if (option != "--" && option != "---" && option != "") {
		document.getElementById(field).value = option;
	} else{
		document.getElementById(field).value = "";
	}
	check_common_options();
}

// On vérifie les options globales
function check_common_options() {
	var day = document.getElementById("day").value;
	select_si_egal(day, "day_options");
	var week = document.getElementById("week").value;
	select_si_egal(week, "week_options");
	var month = document.getElementById("month").value;
	select_si_egal(month, "month_options");
	var cron = day + " " + week + " " + month;
	select_si_egal(cron, "common_options");
}

// Quand on sélectionne une option globale, on paramètre les champs en dessous pour correspondre à la selection
function select_common_option() {
	var option = document.getElementById("common_options").value;
	if (option !== "--"){
		document.getElementById("recurrence").value = option;
		var option_array = option.split(" ");
	} else {
		var option_array= [" ", " ", " "]
	}
	
	document.getElementById("day").value = option_array[0];
	document.getElementById("week").value = option_array[1];
	document.getElementById("month").value = option_array[2];
	check_common_options();

}

// Fonction qui permet de faire coincider le champ texte et son sélecteur
function select_si_egal(value, select_id) {
	var options = document.getElementById(select_id).options;
	var option_found = false;
	for (var i = 0; i < options.length; i++) {
		if (options[i].value == value) {
			options[i].selected = true;
			option_found = true;
		}
	}
	if (option_found == false) {
		options[0].selected = true;
	}
}