$(document).ready(function() {

    // We initialize the modal
    ModalReunion.initialisation( SauvegarderReunion.modal_id );

    if ( ModalReunion.loaded ) {

        // We initialize the onclick function [ Action par lot ]
        SauvegarderReunion.setClickActionLotBtn();
    }

    $('#form_reunion_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_reunion_btn_confirme').click(function(){
        SauvegarderReunion.getRecapModificationReunion();
    });

    $('#form_reunion_btn_sauvegarder').click(function(){
        SauvegarderReunion.modifierReunion();
    });
    
    $('#form_reunion_btn_retour').click(function(){
        RoutingModifierReunion.route( "formulaire_modifier_reunion", null );
        $('#form_reunion_btn_confirme').show();
        $('#form_reunion_btn_terminer').text("Annuler");
    });

});

// We create an instance of the OdeModal object
const ModalReunion = Object.create(OdeModal);

if( typeof(SauvegarderReunion) == 'undefined' ){ var SauvegarderReunion = { modal_id: 'ode_modal_reunion', loaded: false }; }

// We initialize the onclick function [ Action par lot ]
SauvegarderReunion.setClickActionLotBtn = function(){
    $('[role="ode-modal-reunion-btn"]').off().on('click', function () {
        $('#form_reunion_btn_terminer').text('Annuler');
        $('#form_reunion_btn_terminer').show();
        $('#form_reunion_btn_retour').hide();
        ModalReunion.initialisation( SauvegarderReunion.modal_id );
        ModalReunion.open();
        SauvegarderReunion.initialisation();
    });
}

SauvegarderReunion.initialisation = function(){ 

    ModalReunion.route('reunion');
    LoadingModifierReunion.addSpinner($('#modal_modifier_reunion_loading'));    

    var loading = function(){
        //ModalReunion.loading.setMessage('Récupération des dossiers séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalReunion.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result === "string" && this.result != '' ){
            ModalReunion.route('erreur',this.result);
            $('#form_reunion_btn_terminer').show();
            $('#form_reunion_btn_terminer').text('Fermer');
            $('#form_reunion_btn_retour').hide();
            $('#form_reunion_btn_confirme').hide();
            $('#form_reunion_btn_sauvegarder').hide();
            return; 
        }

        var message = ( this.result.nb === 1 ) 
                    ? `Récupération du dossier séléctionné`
                    : `Récupération des ${this.result.nb} dossiers séléctionnés`;

        ModalReunion.route('reunion');
        LoadingModifierReunion.removeSpinner($('#modal_modifier_reunion_loading'));
        retourFunctionModificationReunion.initFormulaireModifierReunion(this);
    };

    var dossiers = SauvegarderReunion.getSelectedDossiers();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_reunion');
    query.setAction("initFormulaireModifierReunion");
    query.setPostData( dossiers );
    OdeAjax.getByAction( query, loading, callBack );
}

SauvegarderReunion.getRecapModificationReunion = function(){ 

    var dossiers = getDataFunctionModificationReunion.getRecapModificationReunion();

    if(dossiers){
        ModalReunion.route('reunion');
        LoadingModifierReunion.addSpinner($('#modal_modifier_reunion_loading'));   

        var loading = function(){
            //ModalReunion.loading.setMessage('Vérification des dossiers séléctionnés');
        };

        var callBack = function(){

            if ( typeof this.result.html_message === "string"){
                ModalReunion.route('erreur',this.result.html_message);
                return; 
            }

            if(typeof this.result === "string" && this.result != '' ){
                ModalReunion.route('erreur',this.result);
                $('#form_reunion_btn_terminer').show();
                $('#form_reunion_btn_terminer').text('Fermer');
                $('#form_reunion_btn_retour').hide();
                $('#form_reunion_btn_confirme').hide();
                $('#form_reunion_btn_sauvegarder').hide();
                return; 
            }

            var message = ( Object.keys(this.result).length === 1 ) 
                        ? `Vérification du dossier séléctionné`
                        : `Vérification des ${Object.keys(this.result).length} dossiers séléctionnés`;

            ModalReunion.route('reunion');
            LoadingModifierReunion.removeSpinner($('#modal_modifier_reunion_loading'));
            retourFunctionModificationReunion.getRecapModificationReunion(this);
        };

        var query = OdeQueries.getAjaxActionQuery();
        query.setModule('OPS_reunion');
        query.setAction("getRecapModificationReunion");
        query.setPostData( dossiers );
        OdeAjax.getByAction( query, loading, callBack );
    }
}

SauvegarderReunion.modifierReunion = function(){ 

    ModalReunion.route('reunion');
    LoadingModifierReunion.addSpinner($('#modal_modifier_reunion_loading'));   

    var loading = function(){
        //ModalReunion.loading.setMessage('Sauvegarde des dossiers séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalReunion.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result === "string" && this.result != '' ){
            ModalReunion.route('erreur',this.result);
            $('#form_reunion_btn_terminer').show();
            $('#form_reunion_btn_terminer').text('Fermer');
            $('#form_reunion_btn_retour').hide();
            $('#form_reunion_btn_confirme').hide();
            $('#form_reunion_btn_sauvegarder').hide();
            return; 
        }

        var message = ( Object.keys(this.result).length === 1 ) 
                    ? `Sauvegarde du dossier séléctionné`
                    : `Sauvegarde des ${Object.keys(this.result).length} dossiers séléctionnés`;

        ModalReunion.route('reunion');
        LoadingModifierReunion.removeSpinner($('#modal_modifier_reunion_loading'));
        retourFunctionModificationReunion.modifierReunion(this);
    };

    var dossiers = getDataFunctionModificationReunion.modifierReunion();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_reunion');
    query.setAction("modifierReunion");
    query.setPostData( dossiers );
    OdeAjax.getByAction( query, loading, callBack );
}

SauvegarderReunion.getSelectedDossiers = function(){
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
            json = $.parseJSON( json );
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    if (document.MassUpdate.uid.value != ''){
        var massUpdate = document.MassUpdate.uid.value;
        massUpdate += ',';
        massUpdate += tabId.join(',');
        tabId = massUpdate.split(',');
        if(tabId[tabId.length - 1] == ''){
            tabId.pop();
        }
    }
    return ( document.MassUpdate.select_entire_list.value == 1 ) ? { dossiers: false, filtres: json } : { dossiers: tabId, filtres: false };
}

var RoutingModifierReunion = {

    route: function (form_name, data) {

        this.forms = this.forms || $('[role="form"]');
        if( this.forms.length === 0 ){ return false; }

        this.initFormulaire(form_name, data);
        this.displayFormulaire();

        return true;
    },

    initFormulaire: function (form_name, data) { 

        switch (form_name) {
            case "resultat_modifier_reunion":
                ModifierReunion.initResultat(data);
                break;
            case "recap_modifier_reunion":
                ModifierReunion.initRecap(data);
                break;
            case "message_modifier_reunion":
                ModifierReunion.initMessage(data);
                break;
            case "loading_modifier_reunion":
                ModifierReunion.initLoading();
                break;
            case "formulaire_modifier_reunion":
                ModifierReunion.initFormulaire( data );
                break;
            default:
                console.log("Formulaire "+form_name+" Non définie dans le Routing.")
                break;
        }

        this.forms.each( function() {  
            ( $(this).attr("data-name") === form_name ) ? $(this).attr("data-selected" , "true") : $(this).attr("data-selected" , "false");
        });  

    },

    displayFormulaire: function () { 
        this.forms.each( function() {
            ( $(this).attr("data-selected") === "true" ) ? $(this).show("fade", { direction: "right", align: "center" }, 500 ) : $(this).hide();
        });
    },
    
};

var ModifierReunion = {

    
    initRecap: function ( data ) {

        var recap_html = this.getLigneRecap( data.result ) ;
        $("#form_reunion_btn_sauvegarder").show();
        $("#form_reunion_btn_confirme").hide();
        $("#form_reunion_btn_retour").show();
        $("#recap_modifier_reunion").empty();
        $("#recap_modifier_reunion").append(recap_html);

    },

    getLigneRecap: function ( dossiers ) {

        var recap_html = '';

        dossiers = Object.entries(dossiers).reverse();
        
        if ( Object.keys(dossiers).length > 0 ){
            Object.keys(dossiers).forEach(function(dossier_num) {
                const dossier = dossiers[dossier_num];
                if ( dossier !== "erreur" ) {
                    recap_html += '<div style="margin: 0px 30px 0px 30px;">';
                    recap_html +=   '<div style="display: block; padding-bottom: 20px;">';
                    recap_html +=       '<h3 style="font-size: 15px;">';
                    recap_html +=           '<span style="float: left;width: 75%;overflow: hidden;text-overflow: ellipsis;" title="'+ dossiers[dossier_num][0] +'" >N° dossier(s): ' + dossiers[dossier_num][0] + '</span>';
                    recap_html +=       '</h3>';
                    recap_html +=   '</div>';
                    recap_html +=   '<div style="display: inline-block;width: 100%;font-size: 15px;margin-left: 20px;margin-top: 10px;">';
                    recap_html +=       '<span style="float: left;">Réunion : &nbsp;</span>';
                    recap_html +=       '<span style="float: left;color: #f3a517;">&nbsp;' + dossier[1].old_reunion + '</span>';
                    recap_html +=       '<span style="float: left;"> &nbsp; ➨ &nbsp; </span>';
                    recap_html +=       '<span style="float: left;color: #019234;">&nbsp;' + dossier[1].new_reunion + '</span>';
                    recap_html +=   '</div>';
                    recap_html += '</div>';
                    recap_html += '<div style="display: block; border-bottom: 1px solid #eee; margin-top: 20px;"></div>';
                }
            });
        }
        return recap_html;
    },

    initResultat: function ( data ) {
        var recap_html = this.getLigneRecap( data.result ) ;
        recap_html += '<h3 style="font-size: 17px;color:green;float: right;margin-right: 2%;">  Les dossiers ont bien été mise à jour</h3>';
        $("#form_reunion_btn_sauvegarder").hide();
        $("#form_reunion_btn_retour").hide();
        $("#form_reunion_btn_terminer").text('Fermer');
        $("#resultat_modifier_reunion").empty();
        $("#resultat_modifier_reunion").append(recap_html);
    },
    
    initLoading: function () {
        LoadingModifierReunion.addSpinner($('#modal_modifier_reunion_loading'));
        $("#form_reunion_btn_confirme").hide();
    },

    initFormulaire: function ( data ) {

        if ( data !== null) {
            var reunions_options_html = '<option></option>';
            const reunions = data.reunions;
            Object.keys(reunions).forEach(function(reunion_id) {
                reunions_options_html += '<option value="' + reunion_id + '">' + reunions[reunion_id] + '</option>';
            });
    
            const dossiers = data.dossiers;
            var formulaire_html = '';
    
            if ( Object.keys(dossiers).length > 0 ){
                Object.keys(dossiers).forEach(function(reunion_id) {
    
                    const reunion = dossiers[reunion_id];
                    var select_id = Math.floor(new Date().valueOf() * Math.random())
    
                    formulaire_html += '<div style="margin: 0px 30px 0px 30px;">';
                    formulaire_html +=  '<div style="display: block; padding-bottom: 20px;">';
                    formulaire_html +=      '<h3 style="font-size: 15px;">';
                    formulaire_html +=          '<div class="row col-md-7" style="height: 90px;overflow-x: hidden;padding: 5px;overflow-wrap: break-word;">';
                    formulaire_html +=              '<div class="col-md-12" style="margin-left: 10px;">';
                    formulaire_html +=                  '<div style="font-weight: bold;" '+ reunion.dossier_num +'>N° dossier(s):</div>';
                    formulaire_html +=              '</div>'   ;    
                    formulaire_html +=              '<div class="col-md-12" style="padding: 14px;">' + reunion.dossier_num + '</div>';        
                    formulaire_html +=          '</div>';
                    formulaire_html +=          '<span style="float: right;color: #35b3c5;">Réunion actuelle: &nbsp;'; 
                    formulaire_html +=              ( reunion.name !== "aucune réunion" ) ? reunion.name : '<span style="color: red;">'+reunion.name+'</span>';
                    formulaire_html +=          '</span>';
                    formulaire_html +=      '</h3>';
                    formulaire_html +=  '</div>';
                    formulaire_html +=  '<div style="display: inline-block;width: 100%;text-align: right;font-size: 15px;">';
                    formulaire_html +=      'Ajouter une réunion:';
                    formulaire_html +=      '<select id="' + select_id + '" onfocus="hideVerificationReunion(' + select_id + ')" class="selectReunion" role="select_reunion" data-dossiers="' + reunion.dossier_id + '" style="width: 22%;margin-left: 10px;">';
                    formulaire_html +=          reunions_options_html;
                    formulaire_html +=      '</select>';
                    formulaire_html +=  '</div>';
                    formulaire_html +=  '<small id="small_' + select_id + '" style="color:red;width: 22%;float: right;display:none;">Veuillez selectionner une réunion</small>';
                    formulaire_html += '</div>';
    
                    formulaire_html += '<div style="display: block; border-bottom: 2px solid #eee; margin-top: 20px;"></div>';
    
                });
            }
    
            $("#formulaire_modifier_reunion").empty();
            $("#formulaire_modifier_reunion").append(formulaire_html);
        }
        
        $("#form_reunion_btn_confirme").show();
        $("#form_reunion_btn_sauvegarder").hide();
        $("#form_reunion_btn_retour").hide();
    },

    initMessage: function ( data ) {
        $("#form_reunion_btn_sauvegarder").hide();
        $("#form_reunion_btn_retour").hide();
        $('#message_modifier_reunion_titre').empty();
        $('#message_modifier_reunion_message').empty();
        $('#message_modifier_reunion_html_message').empty();
        if( typeof data.titre === "string" ) $("#message_modifier_reunion_titre").text( data.titre );
        if( typeof data.message === "string" ) $("#message_modifier_reunion_message").text( data.message );
        if( typeof data.html_message === "string" ) $("#message_modifier_reunion_html_message").append(data.html_message);
    },

}

var LoadingModifierReunion = {

    addSpinner: function (el, static_pos){
        var spinner = el.children('.spinner');
        $(el).show();
        $("#btn_modifier_reunion").hide();
        $("#formulaire_modifier_reunion").hide();
        $("#recap_modifier_reunion").hide();
        $("#resultat_modifier_reunion").hide();
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        var spinner = el.children('.spinner');
        $("#btn_modifier_reunion").show();
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};

// Fonction qui retourne la liste des dossiers 
function getDossiers(){

    var dossiers = false;
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    dossiers = tabId + '&selectAll=0';
    if (document.MassUpdate.select_entire_list.value == 1) {
        dossiers = json + '&selectAll=1';
    }
    return dossiers;

}

// Fonction pour réinitialiser le select apres vérification
function hideVerificationReunion ( select_id ){
    $("#"+ select_id).css("border-color","#a5e8d6");
    $("#small_"+ select_id).hide();
}

// Fonction pour un afficher un border vert sur une séléction valide
function showSuccessReunion ( select_id ){
    $("#"+ select_id).css("border-color","green");
    $("#small_"+ select_id).hide();
}

// Fonction pour afficher l'erreur de séléction d'un statut
function showErreurReunion ( select_id ){
    $("#"+ select_id).css("border-color","red");
    $("#small_"+ select_id).show();
}

// Cette variable regroupe les differentes fonctions des get données pour l'envoie Ajax
var getDataFunctionModificationReunion = {

    initFormulaireModifierReunion: function() {
        var dossiers = getDossiers();
        return ( typeof dossiers === "string" && Object.keys(dossiers).length > 0 ) ? "dossiers=" + dossiers : false;
    },
    getRecapModificationReunion: function() {

        var json = { data: [] };
        var erreur_selection = false;
        if ( $('[role="select_reunion"]').length > 0 ) {
            $('[role="select_reunion"]').each( function( index, select ) {
                if ( $(select).val() !== "" ){
                    json.data.push( { reunion_id: $(select).val(), dossiers: $(select).attr("data-dossiers") } );
                    showSuccessReunion( $(select).attr("id") );
                } else {
                    erreur_selection = true;
                    showErreurReunion( $(select).attr("id") );
                }
            });
        }
        return ( erreur_selection === false && json.data.length > 0 ) ? utf8_to_b64( JSON.stringify( json ) ) : false;
    },
    modifierReunion: function() {

        var json = { data: [] };
        var erreur_selection = false;
        if ( $('[role="select_reunion"]').length > 0 ) {
            $('[role="select_reunion"]').each( function( index, select ) {
                if ( $(select).val() !== "" ){
                    json.data.push( { reunion_id: $(select).val(), dossiers: $(select).attr("data-dossiers") } );
                    showSuccessReunion( $(select).attr("id") );
                } else {
                    erreur_selection = true;
                    showErreurReunion( $(select).attr("id") );
                }
            });
        }
        return ( erreur_selection === false && json.data.length > 0 ) ? utf8_to_b64( JSON.stringify( json ) ) : false;
    }

};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionModificationReunion : Object.assign(getDataFunction, getDataFunctionModificationReunion);

// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionModificationReunion = {

    initFormulaireModifierReunion: function() {
        RoutingModifierReunion.route("loading_modifier_reunion", null);
    },
    getRecapModificationReunion: function() {
        RoutingModifierReunion.route("loading_modifier_reunion", null);
    },
    modifierReunion: function() {
        RoutingModifierReunion.route("loading_modifier_reunion", null);
    },

};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionModificationReunion : Object.assign(loadingFunction, loadingFunctionModificationReunion);

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionModificationReunion = {

    initFormulaireModifierReunion: function(data) {
        var titre = "Erreur d'initilisation du formulaire de modification des réunions";
        if(data){
            if ( data['statut'] === true ) {
                RoutingModifierReunion.route( "formulaire_modifier_reunion", data['result'] );
            } else {
                var message = data['data'];
                RoutingModifierReunion.route( "message_modifier_reunion", { titre: titre, message: message, html_message: null } ); 
            } 
        }else{
            RoutingModifierReunion.route( "message_modifier_reunion", { titre: titre, message: " Erreur de communication avec le serveur, veuillez contacter votre administrateur.",html_message: null } ); 
        }
        
    },
    getRecapModificationReunion: function(data) {
        if(data){
            RoutingModifierReunion.route( "recap_modifier_reunion", data );
        }else{
            RoutingModifierReunion.route( "message_modifier_reunion", { titre: "Initialisation 3", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    modifierReunion: function(data) {
        if(data){
            RoutingModifierReunion.route( "resultat_modifier_reunion", data );
        }else{
            RoutingModifierReunion.route( "message_modifier_reunion", { titre: "Initialisation 3", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    }

};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionModificationReunion : Object.assign(retourFunction, retourFunctionModificationReunion);

