<?php
    
if(!defined('sugarEntry') || !sugarEntry) die ('Not a valid Entry Point');

require_once 'include/MVC/View/views/view.edit.php';

class OPS_suivi_dossierViewEdit extends ViewEdit
{

    public function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }

    public function display()
    {
        parent::display();

        $this->displayTMCE();
    }
    
    public function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale, $mod_strings, $app_list_strings;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $js = '<script src="vendor/tinymce/tinymce/tinymce.min.js"></script>';
        $js .=<<<JS
        <script language="javascript" type="text/javascript">
        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        tinyMCE.init({
            selector: '#description',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            license_key: 'gpl',
            toolbar: 'undo redo | blocks fontfamily fontsizeinput | bold italic underline forecolor backcolor removeformat | align numlist bullist | link image | table quickimage | lineheight indent outdent | pagebreak | code fullscreen preview | wordcount',
            quickbars_selection_toolbar: 'bold italic underline | quicklink h2 h3 blockquote quickimage quicktable',
            inline_styles: true,
            directionality: 'ltr',
            remove_redundant_brs: true,
            entity_encoding: 'raw',
            verify_html: false,
            valid_children: '+a[*]',
            cleanup: false,
            cleanup_on_startup: false,
            convert_urls: false,
            plugin_insertdate_dateFormat: "{DATE {$defaultDateFormat}}",
            pagebreak_separator: '<pagebreak />',
            extended_valid_elements: '*[*]',  // Allow all elements and attributes
            valid_elements: '*[*]',           // Allow all elements and attributes
            custom_elements: 'textblock',
            language: 'fr_FR',
            language_url: '/vendor/tweeb/tinymce-i18n/langs/fr_FR.js',
            promotion: false,
            branding: false,
            relative_urls: false,
            remove_script_host: false,
        });
        </script>

JS;
        echo $js;
    }
}